/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.beans;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.beans.BeanPropertyAccessException;
import com.github.paganini2008.devtools.beans.ExcludedProperty;
import com.github.paganini2008.devtools.beans.PropertyFilter;
import com.github.paganini2008.devtools.beans.PropertyMapper;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.converter.ConvertUtils;
import com.github.paganini2008.devtools.reflection.FieldUtils;
import com.github.paganini2008.devtools.reflection.MethodUtils;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class PropertyUtils {
    private static final Map<Type, Map<Type, Map<String, PropertyDescriptor>>> cache = new LruMap<Type, Map<Type, Map<String, PropertyDescriptor>>>(256);

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass) {
        return PropertyUtils.getPropertyDescriptors(beanClass, null);
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass, Class<?> stopClass) {
        Map<String, PropertyDescriptor> data;
        Map<Type, Map<String, PropertyDescriptor>> map;
        Assert.isNull(beanClass, "Bean class must not be null.", new Object[0]);
        if (stopClass == null) {
            stopClass = Object.class;
        }
        if ((map = cache.get(beanClass)) == null) {
            cache.put(beanClass, new LruMap(16));
            map = cache.get(beanClass);
        }
        if ((data = map.get(stopClass)) == null) {
            map.put(stopClass, PropertyUtils.fetchPropertyDescriptors(beanClass, stopClass));
            data = map.get(stopClass);
        }
        return data;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> beanClass, Class<?> stopClass, PropertyFilter filter) {
        Map<String, PropertyDescriptor> original = PropertyUtils.getPropertyDescriptors(beanClass, stopClass);
        LinkedHashMap<String, PropertyDescriptor> destination = new LinkedHashMap<String, PropertyDescriptor>();
        if (original != null) {
            for (Map.Entry<String, PropertyDescriptor> e : original.entrySet()) {
                if (filter != null && !filter.accept(beanClass, e.getKey(), e.getValue())) continue;
                destination.put(e.getKey(), e.getValue());
            }
        }
        return destination;
    }

    private static Map<String, PropertyDescriptor> fetchPropertyDescriptors(Class<?> beanClass, Class<?> stopClass) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(beanClass, stopClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Invalid bean class '" + beanClass.getName() + "' or stop class '" + stopClass.getName() + "'.", e);
        }
        Object[] descriptors = info.getPropertyDescriptors();
        if (ArrayUtils.isNotEmpty(descriptors)) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(descriptors.length);
            for (Object descriptor : descriptors) {
                data.put(((FeatureDescriptor)descriptor).getName(), descriptor);
            }
            return Collections.unmodifiableMap(data);
        }
        return Collections.EMPTY_MAP;
    }

    public static void populate(Object destination, Map<String, ?> map) {
        PropertyUtils.populate(destination, map, null);
    }

    public static void populate(Object destination, Map<String, ?> map, PropertyFilter filter) {
        PropertyUtils.populate(destination, map, filter, true);
    }

    public static void populate(Object destination, Map<String, ?> map, PropertyFilter filter, boolean overwrited) {
        PropertyUtils.populate(destination, null, map, filter, overwrited);
    }

    public static void populate(Object destination, Class<?> stopClass, Map<String, ?> map, PropertyFilter filter, boolean overwrited) {
        Assert.isNull(destination, "Destination instance must not be null.", new Object[0]);
        Map<String, PropertyDescriptor> dest = PropertyUtils.getPropertyDescriptors(destination.getClass(), stopClass, filter);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Object current;
            String propertyName = entry.getKey();
            PropertyDescriptor descriptor = dest.get(propertyName);
            if (descriptor == null || !overwrited && (current = PropertyUtils.getProperty(destination, descriptor)) != null) continue;
            PropertyUtils.setProperty(destination, descriptor, entry.getValue());
        }
    }

    private static Map<String, PropertyDescriptor> getMappingPropertyDescriptors(Class<?> type) {
        Map<String, PropertyDescriptor> descriptors = PropertyUtils.getPropertyDescriptors(type);
        LinkedHashMap<String, PropertyDescriptor> results = new LinkedHashMap<String, PropertyDescriptor>(descriptors);
        for (Map.Entry<String, PropertyDescriptor> e : descriptors.entrySet()) {
            Method method;
            PropertyMapper mapping;
            String propertyName = e.getKey();
            PropertyDescriptor descriptor = e.getValue();
            Field field = FieldUtils.getFieldIfAbsent(type, propertyName);
            if (field != null) {
                if (field.isAnnotationPresent(ExcludedProperty.class)) {
                    results.remove(propertyName);
                } else if (field.isAnnotationPresent(PropertyMapper.class)) {
                    mapping = field.getAnnotation(PropertyMapper.class);
                    results.put(StringUtils.isBlank(mapping.value()) ? e.getKey() : mapping.value(), descriptor);
                }
            }
            if ((method = descriptor.getWriteMethod()) == null || !method.isAnnotationPresent(PropertyMapper.class)) continue;
            mapping = method.getAnnotation(PropertyMapper.class);
            results.put(StringUtils.isBlank(mapping.value()) ? e.getKey() : mapping.value(), descriptor);
        }
        return results;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        Map<String, PropertyDescriptor> dest = PropertyUtils.getPropertyDescriptors(beanClass, null);
        return dest.get(propertyName);
    }

    public static boolean hasProperty(Class<?> beanClass, String propertyName) {
        Map<String, PropertyDescriptor> dest = PropertyUtils.getPropertyDescriptors(beanClass, null);
        return dest.containsKey(propertyName);
    }

    public static boolean setProperty(Object bean, PropertyDescriptor descriptor, Object value) {
        Assert.isNull(bean, "Source instance must not be null.", new Object[0]);
        Assert.isNull(descriptor, "Property descriptor must not be null.", new Object[0]);
        Method method = descriptor.getWriteMethod();
        Assert.isNull(method, "Cannot find the setter of '" + descriptor.getName() + "'.", new Object[0]);
        return PropertyUtils.setProperty(bean, method, descriptor.getPropertyType(), value);
    }

    private static boolean setProperty(Object bean, Method method, Class<?> propertyType, Object value) {
        Object realValue;
        try {
            realValue = propertyType.cast(value);
        }
        catch (RuntimeException e) {
            realValue = ConvertUtils.convertValue(value, propertyType);
        }
        if (realValue == null && propertyType.isPrimitive()) {
            return false;
        }
        PropertyUtils.invokeSetter(bean, method, realValue);
        return true;
    }

    public static boolean setProperty(Object bean, String propertyName, Object value) {
        int index = propertyName.indexOf(46);
        if (index > 0) {
            bean = PropertyUtils.getProperty(bean, propertyName.substring(0, index));
            return PropertyUtils.setProperty(bean, propertyName.substring(index + 1), value);
        }
        Assert.isNull(bean, "Source instance must not be null.", new Object[0]);
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean.getClass(), propertyName);
        Assert.isNull(descriptor, "Property '" + propertyName + "' is not found in class '" + bean.getClass().getName() + "'.", new Object[0]);
        return PropertyUtils.setProperty(bean, descriptor, value);
    }

    public static Object getProperty(Object bean, PropertyDescriptor descriptor) {
        Assert.isNull(bean, "Source instance must not be null.", new Object[0]);
        Assert.isNull(descriptor, "Property descriptor must not be null.", new Object[0]);
        Method method = descriptor.getReadMethod();
        Assert.isNull(method, "Cannot find the getter of '" + descriptor.getName() + "'.", new Object[0]);
        return PropertyUtils.invokeGetter(bean, method);
    }

    public static Object getProperty(Object bean, String propertyName) {
        Assert.isNull(bean, "Source instance must not be null.", new Object[0]);
        Assert.hasNoText(propertyName, "PropertyName must not be null or empty.", new Object[0]);
        int index = propertyName.indexOf(46);
        if (index > 0) {
            bean = PropertyUtils.getProperty(bean, propertyName.substring(0, index));
            return PropertyUtils.getProperty(bean, propertyName.substring(index + 1));
        }
        PropertyDescriptor descriptor = PropertyUtils.getPropertyDescriptor(bean.getClass(), propertyName);
        Assert.isNull(descriptor, "Property '" + propertyName + "' is not found in class '" + bean.getClass().getName() + "'.", new Object[0]);
        return PropertyUtils.getProperty(bean, descriptor);
    }

    public static void copyProperties(Object original, Object destination) {
        PropertyUtils.copyProperties(original, destination, null);
    }

    public static void copyProperties(Object original, Object destination, PropertyFilter filter) {
        PropertyUtils.copyProperties(original, destination, filter, true);
    }

    public static void copyProperties(Object original, Object destination, PropertyFilter filter, boolean overwrited) {
        PropertyUtils.copyProperties(original, null, destination, filter, overwrited);
    }

    public static void copyProperties(Object original, Class<?> stopClass, Object destination, PropertyFilter filter, boolean overwrited) {
        PropertyUtils.copyProperties(original, stopClass, destination, filter, overwrited, false);
    }

    public static void copyProperties(Object original, Class<?> stopClass, Object destination, PropertyFilter filter, boolean overwrited, boolean mappingProperty) {
        Assert.isNull(original, "Source instance must not be null.", new Object[0]);
        Assert.isNull(destination, "Destination instance must not be null.", new Object[0]);
        Map<String, PropertyDescriptor> orig = PropertyUtils.getPropertyDescriptors(original.getClass(), stopClass, filter);
        Map<String, PropertyDescriptor> dest = mappingProperty ? PropertyUtils.getMappingPropertyDescriptors(destination.getClass()) : PropertyUtils.getPropertyDescriptors(destination.getClass());
        PropertyUtils.proceedCopyProperties(original, orig, destination, dest, overwrited);
    }

    private static void proceedCopyProperties(Object original, Map<String, PropertyDescriptor> orig, Object destination, Map<String, PropertyDescriptor> dest, boolean overwrited) {
        for (Map.Entry<String, PropertyDescriptor> entry : dest.entrySet()) {
            Object value;
            Object current;
            String path = entry.getKey();
            PropertyDescriptor descriptor = entry.getValue();
            if (!overwrited && (current = PropertyUtils.getProperty(destination, descriptor)) != null) continue;
            try {
                value = PropertyUtils.getProperty(original, path);
            }
            catch (RuntimeException ignored) {
                value = null;
            }
            PropertyUtils.setProperty(destination, descriptor, value);
        }
    }

    public static Map<String, Object> convertToMap(Object bean) {
        return PropertyUtils.convertToMap(bean, null);
    }

    public static Map<String, Object> convertToMap(Object bean, Class<?> stopClass) {
        return PropertyUtils.convertToMap(bean, stopClass, null);
    }

    public static Map<String, Object> convertToMap(Object bean, Class<?> stopClass, PropertyFilter filter) {
        Assert.isNull(bean, "Source instance must not be null.", new Object[0]);
        Map<String, PropertyDescriptor> dest = PropertyUtils.getPropertyDescriptors(bean.getClass(), stopClass, filter);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, PropertyDescriptor> entry : dest.entrySet()) {
            PropertyDescriptor descriptor = entry.getValue();
            map.put(entry.getKey(), PropertyUtils.getProperty(bean, descriptor));
        }
        return map;
    }

    private static Object invokeSetter(Object bean, Method method, Object value) {
        try {
            return MethodUtils.invokeMethod(bean, method, value);
        }
        catch (Exception e) {
            throw new BeanPropertyAccessException("Cannot access the setter '" + method.getName() + "' on bean '" + bean.getClass().getName() + "'.", e);
        }
    }

    private static Object invokeGetter(Object bean, Method method) {
        try {
            return MethodUtils.invokeMethod(bean, method, new Object[0]);
        }
        catch (Exception e) {
            throw new BeanPropertyAccessException("Cannot access the getter '" + method.getName() + "' on bean '" + bean.getClass().getName() + "'.", e);
        }
    }
}

