/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.beans;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.beans.PropertyFilter;
import com.github.paganini2008.devtools.beans.PropertyFilters;
import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.beans.ToStringStyle;
import com.github.paganini2008.devtools.beans.ToStringStyles;
import com.github.paganini2008.devtools.collection.MapUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class ToStringBuilder {
    private static final ToStringStyle DEFAULT_STYLE = new ToStringStyles.DefaultToSringStyle();
    private static final ToStringStyle PLAIN_STYLE = new ToStringStyles.PlainToStringStyle();
    private static final ToStringStyle SINGLE_LINE_STYLE = new ToStringStyles.SingleLineToSrtingStyle();
    private static final ToStringStyle MULTI_LINE_STYLE = new ToStringStyles.MultiLineToStringStyle();

    public static String reflectionToString(Object target) {
        return ToStringBuilder.reflectionToString(target, (PrintStyle)null);
    }

    public static String reflectionToString(Object target, PrintStyle style) {
        return ToStringBuilder.reflectionToString(target, (PropertyFilter)null, style);
    }

    public static String reflectionToString(Object target, String[] excludedProperties) {
        return ToStringBuilder.reflectionToString(target, PropertyFilters.excludedProperties(excludedProperties));
    }

    public static String reflectionToString(Object target, PropertyFilter filter) {
        return ToStringBuilder.reflectionToString(target, filter, (PrintStyle)null);
    }

    public static String reflectionToString(Object bean, PropertyFilter filter, PrintStyle style) {
        if (style == null) {
            style = PrintStyle.DEFAULT;
        }
        return ToStringBuilder.reflectionToString(bean, null, filter, style.getStyle());
    }

    public static String reflectionToString(Object bean, PropertyFilter filter, ToStringStyle style) {
        return ToStringBuilder.reflectionToString(bean, null, filter, style);
    }

    public static String reflectionToString(Object bean, Class<?> stopClass, PropertyFilter filter, ToStringStyle style) {
        Map<String, PropertyDescriptor> descriptors;
        Assert.isNull(bean, "Source object must not be null.", new Object[0]);
        PropertyFilter propertyFilter = new PublicPropertyFilter();
        if (filter != null) {
            propertyFilter = propertyFilter.and(filter);
        }
        if (MapUtils.isEmpty(descriptors = PropertyUtils.getPropertyDescriptors(bean.getClass(), stopClass, propertyFilter))) {
            return "";
        }
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        return style.toString(bean, descriptors.values());
    }

    static /* synthetic */ ToStringStyle access$000() {
        return DEFAULT_STYLE;
    }

    static /* synthetic */ ToStringStyle access$100() {
        return PLAIN_STYLE;
    }

    static /* synthetic */ ToStringStyle access$200() {
        return SINGLE_LINE_STYLE;
    }

    static /* synthetic */ ToStringStyle access$300() {
        return MULTI_LINE_STYLE;
    }

    private static class PublicPropertyFilter
    implements PropertyFilter {
        private PublicPropertyFilter() {
        }

        @Override
        public boolean accept(Class<?> type, String name, PropertyDescriptor descriptor) {
            Method getter = descriptor.getReadMethod();
            if (getter != null) {
                return getter.getModifiers() == 1 || getter.getModifiers() == 4 || getter.getModifiers() == 0;
            }
            return false;
        }
    }

    public static enum PrintStyle {
        DEFAULT(ToStringBuilder.access$000()),
        PLAIN(ToStringBuilder.access$100()),
        SINGLE_LINE(ToStringBuilder.access$200()),
        MULTI_LINE(ToStringBuilder.access$300());

        private final ToStringStyle style;

        private PrintStyle(ToStringStyle style) {
            this.style = style;
        }

        public ToStringStyle getStyle() {
            return this.style;
        }

        public static PrintStyle get(String name) {
            for (PrintStyle style : PrintStyle.values()) {
                if (!style.name().equalsIgnoreCase(name)) continue;
                return style;
            }
            return null;
        }
    }
}

