/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.beans;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.beans.ToStringStyle;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.Iterator;

public abstract class ToStringStyles {
    private static final String NEWLINE = System.getProperty("line.separator");

    public static class SingleLineToSrtingStyle
    implements ToStringStyle {
        @Override
        public String toString(Object bean, Collection<PropertyDescriptor> descriptors) {
            Assert.isNull(bean, "Source object must not be null.", new Object[0]);
            StringBuilder str = new StringBuilder();
            str.append(bean.getClass().getName());
            str.append("@").append(bean.hashCode());
            str.append("{");
            if (CollectionUtils.isNotEmpty(descriptors)) {
                int i = 0;
                for (PropertyDescriptor descriptor : descriptors) {
                    str.append(descriptor.getName()).append(": ").append(PropertyUtils.getProperty(bean, descriptor));
                    if (i++ == descriptors.size() - 1) continue;
                    str.append(", ");
                }
            }
            str.append("}");
            return str.toString();
        }
    }

    public static class MultiLineToStringStyle
    implements ToStringStyle {
        @Override
        public String toString(Object bean, Collection<PropertyDescriptor> descriptors) {
            Assert.isNull(bean, "Source object must not be null.", new Object[0]);
            StringBuilder str = new StringBuilder("");
            str.append(bean.getClass().getName());
            str.append("@").append(bean.hashCode());
            str.append(" ");
            str.append("{");
            if (CollectionUtils.isNotEmpty(descriptors)) {
                str.append(NEWLINE);
                for (PropertyDescriptor descriptor : descriptors) {
                    str.append(StringUtils.padding(4));
                    str.append(descriptor.getName()).append(": ").append(PropertyUtils.getProperty(bean, descriptor));
                    str.append(NEWLINE);
                }
            }
            str.append("}");
            return str.toString();
        }
    }

    public static class DefaultToSringStyle
    implements ToStringStyle {
        @Override
        public String toString(Object bean, Collection<PropertyDescriptor> descriptors) {
            Assert.isNull(bean, "Source object must not be null.", new Object[0]);
            StringBuilder str = new StringBuilder();
            str.append("{");
            if (CollectionUtils.isNotEmpty(descriptors)) {
                int i = 0;
                for (PropertyDescriptor descriptor : descriptors) {
                    str.append(descriptor.getName()).append(": ").append(PropertyUtils.getProperty(bean, descriptor));
                    if (i++ == descriptors.size() - 1) continue;
                    str.append(", ");
                }
            }
            str.append("}");
            return str.toString();
        }
    }

    public static class PlainToStringStyle
    implements ToStringStyle {
        @Override
        public String toString(Object bean, Collection<PropertyDescriptor> descriptors) {
            Assert.isNull(bean, "Source object must not be null.", new Object[0]);
            StringBuilder str = new StringBuilder();
            str.append("{");
            if (CollectionUtils.isNotEmpty(descriptors)) {
                Iterator<PropertyDescriptor> it = descriptors.iterator();
                while (true) {
                    PropertyDescriptor descriptor = it.next();
                    str.append(PropertyUtils.getProperty(bean, descriptor));
                    if (!it.hasNext()) break;
                    str.append(",");
                }
            }
            str.append("}");
            return str.toString();
        }
    }
}

