/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.CheckedExpiredCache;
import com.github.paganini2008.devtools.cache.ExpiredCache;
import com.github.paganini2008.devtools.cache.FifoCache;
import com.github.paganini2008.devtools.cache.LifoCache;
import com.github.paganini2008.devtools.cache.LimitedCache;
import com.github.paganini2008.devtools.cache.LruCache;
import com.github.paganini2008.devtools.cache.MasterStandbyCache;
import com.github.paganini2008.devtools.cache.SortedCache;
import com.github.paganini2008.devtools.cache.Store;
import com.github.paganini2008.devtools.cache.UncheckedExpiredCache;
import java.util.Iterator;

public abstract class AbstractCache
implements Cache {
    public LimitedCache fifo(int maxSize, Store store) {
        FifoCache cache = new FifoCache(this, maxSize);
        ((LimitedCache)cache).setStore(store);
        return cache;
    }

    public LimitedCache lifo(int maxSize, Store store) {
        LifoCache cache = new LifoCache(this, maxSize);
        ((LimitedCache)cache).setStore(store);
        return cache;
    }

    public LimitedCache lru(int maxSize, Store store) {
        LruCache cache = new LruCache(this, maxSize);
        ((LimitedCache)cache).setStore(store);
        return cache;
    }

    public LimitedCache sort(int maxSize, boolean asc, Store store) {
        SortedCache cache = new SortedCache(this, maxSize, asc);
        ((LimitedCache)cache).setStore(store);
        return cache;
    }

    public Cache masterStandby(Cache backup) {
        return new MasterStandbyCache(this, backup);
    }

    public ExpiredCache expiredCache(int interval) {
        return new CheckedExpiredCache(this, interval);
    }

    public ExpiredCache expiredCache() {
        return new UncheckedExpiredCache(this);
    }

    public Object getObject(Object key, Object defaultValue) {
        Object o = this.getObject(key);
        if (o == null && (o = defaultValue) != null) {
            this.putObject(key, o);
            o = this.getObject(key);
        }
        return o;
    }

    @Override
    public Iterator<Object> iterator() {
        return new CacheIterator(this);
    }

    static class CacheIterator
    implements Iterator<Object> {
        private final Cache delegate;
        private final Iterator<Object> it;
        private Object key;

        CacheIterator(Cache delegate) {
            this.delegate = delegate;
            this.it = delegate.keys().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            this.key = this.it.next();
            return this.delegate.getObject(this.key);
        }

        @Override
        public void remove() {
            this.delegate.removeObject(this.key);
        }
    }
}

