/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.AbstractCache;
import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.ExpiredCache;
import com.github.paganini2008.devtools.cache.UncheckedExpiredCache;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.TimeUnit;

public class CheckedExpiredCache
extends AbstractCache
implements ExpiredCache {
    private final ExpiredCache delegate;
    private Timer timer;

    public CheckedExpiredCache(Cache delegate, int interval) {
        this.delegate = delegate instanceof ExpiredCache ? (ExpiredCache)delegate : new UncheckedExpiredCache(delegate);
        this.timer = ThreadUtils.scheduleAtFixedRate(() -> {
            this.refresh();
            return true;
        }, 1L, TimeUnit.SECONDS);
    }

    public void refresh() {
        Set<Object> keys = this.delegate.keys();
        for (Object key : keys) {
            this.delegate.getObject(key);
        }
    }

    @Override
    public void putObject(Object key, Object value) {
        this.delegate.putObject(key, value);
    }

    @Override
    public Object getObject(Object key) {
        return this.delegate.getObject(key);
    }

    @Override
    public Object removeObject(Object key) {
        return this.delegate.getObject(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public Set<Object> keys() {
        return this.delegate.keys();
    }

    @Override
    public void putObject(Object key, Object value, int expired) {
        this.delegate.putObject(key, value, expired);
    }

    @Override
    public void setExpired(Object key, int expired) {
        this.delegate.setExpired(key, expired);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.delegate.hasKey(key);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void close() {
        this.delegate.close();
        this.timer.cancel();
    }
}

