/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.Store;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.SerializationUtils;
import com.github.paganini2008.devtools.logging.Log;
import com.github.paganini2008.devtools.logging.LogFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class SerializableStore
implements Store {
    private static final Log logger = LogFactory.getLog(SerializableStore.class);
    public static final String fileExtension = ".cache";
    private String storeDir = FileUtils.getTempDirectoryPath();
    private final LruMap<Object, File> cache;

    public SerializableStore(int maxSize) {
        this.cache = new LruMap<Object, File>(maxSize){
            private static final long serialVersionUID = 8262093056909008093L;

            @Override
            public void onEviction(Object element, File file) {
                try {
                    FileUtils.deleteFile(file);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Remove object from disk: " + file);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), e);
                }
            }
        };
    }

    public void setStoreDir(String storeDir) {
        this.storeDir = storeDir;
    }

    protected File asFile(String name) {
        String fileName = UUID.nameUUIDFromBytes(name.getBytes()).toString();
        return FileUtils.getFile(this.storeDir, fileName + fileExtension);
    }

    @Override
    public void writeObject(Object name, Object o) {
        File file = this.asFile(name.toString());
        SerializationUtils.writeObject(o, file, false);
        this.cache.put(name, file);
        if (logger.isDebugEnabled()) {
            logger.debug("Write object to disk: " + file);
        }
    }

    @Override
    public Object readObject(Object name) {
        File file = this.asFile(name.toString());
        if (logger.isDebugEnabled()) {
            logger.debug("Read object from disk: " + file);
        }
        return SerializationUtils.readObject(file, false);
    }

    @Override
    public Object removeObject(Object name) {
        Object obj = this.readObject(name);
        if (obj != null) {
            File file = this.asFile(name.toString());
            if (logger.isDebugEnabled()) {
                logger.debug("Remove object from disk: " + file);
            }
            try {
                FileUtils.deleteFile(file);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), e);
            }
            this.cache.remove(name);
        }
        return obj;
    }

    @Override
    public int getSize() {
        return this.cache.size();
    }

    @Override
    public Set<Object> keys() {
        return new HashSet<Object>(this.cache.keySet());
    }
}

