/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class LruList<E>
extends AbstractList<E>
implements List<E>,
Serializable {
    private static final long serialVersionUID = -216068975490011223L;
    private final List<E> delegate;
    private final AtomicInteger index = new AtomicInteger(0);
    private final Map<Integer, E> keys;

    public LruList() {
        this(128);
    }

    public LruList(int maxSize) {
        this(new CopyOnWriteArrayList(), maxSize);
    }

    public LruList(final List<E> delegate, final int maxSize) {
        this.delegate = delegate;
        this.keys = Collections.synchronizedMap(new LinkedHashMap<Integer, E>(16, 0.75f, true){
            private static final long serialVersionUID = -3128504588768026293L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, E> eldest) {
                boolean result;
                boolean bl = result = this.size() > maxSize;
                if (result) {
                    delegate.remove(eldest.getValue());
                    LruList.this.onEviction(eldest.getValue());
                }
                return result;
            }
        });
    }

    @Override
    public boolean add(E e) {
        this.keys.put(this.index.getAndIncrement(), e);
        return this.delegate.add(e);
    }

    @Override
    public boolean contains(Object o) {
        this.keys.get(this.delegate.indexOf(o));
        return this.delegate.contains(o);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public boolean remove(Object o) {
        this.keys.remove(this.delegate.indexOf(o));
        return this.delegate.remove(o);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public E get(int index) {
        this.keys.get(index);
        return this.delegate.get(index);
    }

    @Override
    public void add(int index, E e) {
        this.keys.put(index, e);
        this.delegate.add(index, e);
    }

    @Override
    public E set(int index, E e) {
        this.keys.put(index, e);
        return this.delegate.set(index, e);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    protected void onEviction(E e) {
    }
}

