/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class LruQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 7243844578649162100L;
    private final Queue<E> delegate;
    private final int maxSize;
    private final AtomicInteger index = new AtomicInteger(0);
    private final Map<Integer, E> keys;

    public LruQueue() {
        this(128);
    }

    public LruQueue(int maxSize) {
        this(new ConcurrentLinkedQueue(), maxSize);
    }

    public LruQueue(final Queue<E> delegate, final int maxSize) {
        this.delegate = delegate;
        this.maxSize = maxSize;
        this.keys = Collections.synchronizedMap(new LinkedHashMap<Integer, E>(16, 0.75f, true){
            private static final long serialVersionUID = -4000636962958369285L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, E> eldest) {
                boolean result = this.size() > maxSize;
                if (result) {
                    delegate.remove(eldest.getValue());
                    LruQueue.this.onEviction(eldest.getValue());
                }
                return result;
            }
        });
    }

    @Override
    public boolean offer(E e) {
        this.keys.put(this.index.incrementAndGet(), e);
        return this.delegate.offer(e);
    }

    @Override
    public E poll() {
        this.keys.remove(this.index.get() - this.maxSize - 1);
        return this.delegate.poll();
    }

    @Override
    public E peek() {
        this.keys.get(this.index.get() - this.maxSize - 1);
        return this.delegate.peek();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    protected void onEviction(E e) {
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public static void main(String[] args) {
        LruQueue<String> q = new LruQueue<String>(1000);
        for (int i = 0; i < 1000000; ++i) {
            q.add(String.valueOf(i));
        }
        System.out.println((String)q.poll());
        System.out.println((String)q.poll());
        System.out.println((String)q.poll());
        System.out.println((String)q.poll());
        System.out.println((String)q.poll());
    }
}

