/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class LruSet<E>
extends AbstractSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 1472051002956521109L;
    private final Set<E> delegate;
    private final Map<E, Object> keys;

    public LruSet() {
        this(128);
    }

    public LruSet(int maxSize) {
        this(new CopyOnWriteArraySet(), maxSize);
    }

    public LruSet(final Set<E> delegate, final int maxSize) {
        this.delegate = delegate;
        this.keys = Collections.synchronizedMap(new LinkedHashMap<E, Object>(16, 0.75f, true){
            private static final long serialVersionUID = -1535588414267472317L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<E, Object> eldest) {
                boolean result;
                boolean bl = result = this.size() > maxSize;
                if (result) {
                    Object eldestValue = eldest.getKey();
                    delegate.remove(eldestValue);
                    LruSet.this.onEviction(eldestValue);
                }
                return result;
            }
        });
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean contains(Object o) {
        this.keys.get(o);
        return this.delegate.contains(o);
    }

    @Override
    public boolean add(E e) {
        this.keys.put(e, e);
        return this.delegate.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.keys.remove(o);
        return this.delegate.remove(o);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.delegate.clear();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    protected void onEviction(E e) {
    }
}

