/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.converter.ConvertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class MapUtils {
    public static boolean isMap(Object obj) {
        return obj == null ? false : obj instanceof Map;
    }

    public static boolean isNotMap(Object obj) {
        return !MapUtils.isMap(obj);
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        return MapUtils.getOrDefault(map, key, null);
    }

    public static <K, V> V getOrThrown(Map<K, V> map, K key, RuntimeException e) {
        V value = null;
        if (map != null) {
            value = map.get(key);
        }
        if (value == null) {
            throw e;
        }
        return value;
    }

    public static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
        if (map != null) {
            V value = map.get(key);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    public static <K, V> V get(Map<K, V> map, K key, Supplier<V> supplier) {
        V value = map.get(key);
        if (value == null) {
            map.putIfAbsent(key, supplier.get());
            value = map.get(key);
        }
        return value;
    }

    public static <K, V> V get(Map<K, V> map, K key, Function<K, V> function) {
        V value = map.get(key);
        if (value == null) {
            map.putIfAbsent(key, function.apply(key));
            value = map.get(key);
        }
        return value;
    }

    public static <E> List<E> toList(Map<E, E> map) {
        if (map != null) {
            ArrayList<E> list = new ArrayList<E>();
            for (Map.Entry<E, E> e : map.entrySet()) {
                list.add(e.getKey());
                list.add(e.getValue());
            }
        }
        return null;
    }

    public static <K, V> List<Map.Entry<K, V>> toEntries(Map<K, V> map) {
        if (map != null) {
            return new ArrayList<Map.Entry<K, V>>(map.entrySet());
        }
        return null;
    }

    private static <K, V> int indexFor(Map<K, V> map, int index) {
        int size = map.size();
        if (index > size - 1) {
            throw new IllegalArgumentException("Index out of bound: " + index);
        }
        if (index < 0) {
            index = size - Math.abs(index);
        }
        return Math.min(size - 1, index);
    }

    public static <K, V> Map.Entry<K, V> getFirstEntry(Map<K, V> map) {
        return MapUtils.getEntry(map, 0);
    }

    public static <K, V> Map.Entry<K, V> getLastEntry(Map<K, V> map) {
        return MapUtils.getEntry(map, -1);
    }

    public static void main(String[] args) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("a", "123");
        map.put("b", "234");
        map.put("c", "345");
        System.out.println(MapUtils.getFirstEntry(map));
    }

    public static <K, V> Map.Entry<K, V> getEntry(Map<K, V> map, int index) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        index = MapUtils.indexFor(map, index);
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        for (int i = 0; it.hasNext() && i < index; ++i) {
            it.next();
        }
        return it.hasNext() ? it.next() : null;
    }

    public static <T> T get(Map<String, ?> map, String key, Class<T> requiredType, T defaultValue) {
        Object object = map.get(key);
        try {
            return requiredType.cast(object);
        }
        catch (RuntimeException e) {
            return ConvertUtils.convertValue(object, requiredType);
        }
    }

    public static <K, V> void putAll(Map<K, V> map, Collection<Map.Entry<K, V>> entries) {
        if (CollectionUtils.isNotEmpty(entries)) {
            for (Map.Entry<K, V> e : entries) {
                map.put(e.getKey(), e.getValue());
            }
        }
    }

    public static <K, V> void putAll(Map<K, V> map, Map.Entry<K, V>[] entries) {
        if (ArrayUtils.isNotEmpty(entries)) {
            for (Map.Entry<K, V> e : entries) {
                map.put(e.getKey(), e.getValue());
            }
        }
    }

    public static <K, V> void removeKeys(Map<K, V> map, Collection<K> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            for (K key : keys) {
                map.remove(key);
            }
        }
    }

    public static <K, V> void removeKeys(Map<K, V> map, K[] keys) {
        if (ArrayUtils.isNotEmpty(keys)) {
            for (K key : keys) {
                map.remove(key);
            }
        }
    }

    public static <K, V> void retainKeys(Map<K, V> map, Collection<K> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                K o = it.next().getKey();
                if (keys.contains(o)) continue;
                it.remove();
            }
        }
    }

    public static <K, V> void retainKeys(Map<K, V> map, K[] keys) {
        if (ArrayUtils.isNotEmpty(keys)) {
            Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                K o = it.next().getKey();
                if (!ArrayUtils.notContains(keys, o)) continue;
                it.remove();
            }
        }
    }

    public static <K, V> void retainValues(Map<K, V> map, Collection<K> values) {
        Assert.isNull(map, "Map must not be null.", new Object[0]);
        if (CollectionUtils.isNotEmpty(values)) {
            Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                V o = it.next().getValue();
                if (values.contains(o)) continue;
                it.remove();
            }
        }
    }

    public static <K, V> void retainValues(Map<K, V> map, K[] values) {
        Assert.isNull(map, "Map must not be null.", new Object[0]);
        if (ArrayUtils.isNotEmpty(values)) {
            Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                V o = it.next().getValue();
                if (!ArrayUtils.notContains(values, o)) continue;
                it.remove();
            }
        }
    }

    public static <K, V> Map<K, V> toMap(K[] left, V[] right) {
        LinkedHashMap<K, V> results = new LinkedHashMap<K, V>();
        int leftLen = left.length;
        int rightLen = right.length;
        if (leftLen > rightLen) {
            int i;
            for (i = 0; i < rightLen; ++i) {
                results.put(left[i], right[i]);
            }
            while (i < leftLen) {
                results.put(left[i], null);
                ++i;
            }
        } else if (leftLen < rightLen) {
            int i;
            for (i = 0; i < leftLen; ++i) {
                results.put(left[i], right[i]);
            }
            while (i < rightLen) {
                results.put(null, right[i]);
                ++i;
            }
        } else {
            for (int i = 0; i < leftLen; ++i) {
                results.put(left[i], right[i]);
            }
        }
        return results;
    }

    public static <T> Map<T, T> toMap(T ... args) {
        LinkedHashMap<Object, T> results = new LinkedHashMap<Object, T>();
        Object prev = null;
        for (T arg : args) {
            if (prev == null) {
                prev = arg;
                continue;
            }
            results.put(prev, arg);
            prev = null;
        }
        if (prev != null) {
            results.put(prev, null);
        }
        return results;
    }

    public static <T> Map<T, T> toMap(Collection<T> c) {
        Assert.isNull(c, "Collection must not be null.", new Object[0]);
        return MapUtils.toMap(c.iterator());
    }

    public static <T> Map<T, T> toMap(Iterator<T> it) {
        Assert.isNull(it, "Iterator must not be null.", new Object[0]);
        LinkedHashMap<Object, Object> results = new LinkedHashMap<Object, Object>();
        Object prev = null;
        Object item = null;
        while (it.hasNext()) {
            item = it.next();
            if (prev == null) {
                prev = item;
                continue;
            }
            results.put(prev, item);
            prev = null;
        }
        if (prev != null) {
            results.put(prev, null);
        }
        return results;
    }

    public static <T> Map<T, T> toMap(Enumeration<T> en) {
        Assert.isNull(en, "Enumeration must not be null.", new Object[0]);
        LinkedHashMap<Object, Object> results = new LinkedHashMap<Object, Object>();
        Object prev = null;
        Object item = null;
        while (en.hasMoreElements()) {
            item = en.nextElement();
            if (prev == null) {
                prev = item;
                continue;
            }
            results.put(prev, item);
            prev = null;
        }
        if (prev != null) {
            results.put(prev, null);
        }
        return results;
    }

    public static <K, V> Map<V, K> invert(Map<K, V> map) {
        Assert.isNull(map, "Source map must not be null.", new Object[0]);
        LinkedHashMap<V, K> results = new LinkedHashMap<V, K>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            results.put(entry.getValue(), entry.getKey());
        }
        return results;
    }

    public static <K, V> Map<K, V> union(Map<K, V> src, Map<K, V> dest) {
        if (src == null && dest != null) {
            return dest;
        }
        if (src != null && dest == null) {
            return src;
        }
        if (src != null && dest != null) {
            LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
            result.putAll(src);
            result.putAll(dest);
            return result;
        }
        return null;
    }

    public static <K, V> Map<K, V> minus(Map<K, V> src, Map<K, V> dest) {
        if (src == null && dest != null) {
            return dest;
        }
        if (src != null && dest == null) {
            return src;
        }
        if (src != null && dest != null) {
            LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
            for (Map.Entry<K, V> e : src.entrySet()) {
                if (dest.containsKey(e.getKey())) continue;
                result.put(e.getKey(), e.getValue());
            }
            return result;
        }
        return null;
    }

    public static <K, V> Map<K, V> intersect(Map<K, V> src, Map<K, V> dest) {
        if (src == null || dest == null) {
            return null;
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> e : src.entrySet()) {
            if (!dest.containsKey(e.getKey())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static <K, V> String join(Map<K, V> map) {
        return MapUtils.join(map, ",");
    }

    public static <K, V> String join(Map<K, V> map, String delimiter) {
        return MapUtils.join(map, delimiter, delimiter);
    }

    public static <K, V> String join(Map<K, V> map, String conjunction, String delimiter) {
        if (map == null) {
            return "";
        }
        Iterator<Map.Entry<K, V>> it = map.entrySet().iterator();
        if (!it.hasNext()) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder("");
        while (true) {
            Map.Entry<K, V> e = it.next();
            K k = e.getKey();
            V v = e.getValue();
            content.append(ObjectUtils.toString(k)).append(conjunction).append(ObjectUtils.toString(v));
            if (!it.hasNext()) break;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static String toString(Map map) {
        return "{" + MapUtils.join(map, "=", ",") + "}";
    }

    public static boolean isEmpty(Map map) {
        return map == null ? true : map.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtils.isEmpty(map);
    }

    public static <K, V> Map<K, V> compareDifference(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return null;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left != null && right == null) {
            return left;
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> e : left.entrySet()) {
            K k = e.getKey();
            V v = e.getValue();
            if (!ObjectUtils.notEquals(right.get(k), v)) continue;
            result.put(k, v);
        }
        return result;
    }

    public static <K, V> boolean deepEquals(Map<K, V> left, Map<K, V> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        int size = left.size();
        if (right.size() != size) {
            return false;
        }
        for (Map.Entry<K, V> e : left.entrySet()) {
            K k = e.getKey();
            V v = e.getValue();
            if (!ObjectUtils.notEquals(right.get(k), v)) continue;
            return false;
        }
        return true;
    }

    public static <K, V> int deepHashCode(Map<K, V> map) {
        Assert.isNull(map, "Source map must not be null.", new Object[0]);
        int hash = 37;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            hash *= ObjectUtils.hashCode(key) + ObjectUtils.hashCode(value);
        }
        return hash;
    }

    public static <K, V> Map<K, String> formats(Map<K, V> map, String format) {
        Assert.isNull(map, "Map must not be null.", new Object[0]);
        LinkedHashMap<K, String> results = new LinkedHashMap<K, String>();
        for (Map.Entry<K, V> en : map.entrySet()) {
            results.put(en.getKey(), String.format(format, en.getValue()));
        }
        return results;
    }

    public static <K, V> Map<K, V> sort(Map<K, V> map, Comparator<Map.Entry<K, V>> c) {
        Assert.isNull(map, "Map must not be null.", new Object[0]);
        LinkedHashMap result = new LinkedHashMap();
        if (map.size() > 0) {
            ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
            ListUtils.sort(list, c);
            MapUtils.putAll(result, list);
        }
        return result;
    }

    public static Map<String, String> mergeProperties(Properties left, Properties right, Map<String, String> output) {
        Map<String, String> t = MapUtils.toMap(left);
        HashMap<String, String> prevs = new HashMap<String, String>();
        Enumeration<?> en = right.propertyNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String prev = t.put(name, right.getProperty(name));
            if (prev == null) continue;
            prevs.put(name, prev);
        }
        output.putAll(t);
        return prevs;
    }

    public static Map<String, String> toMap(Properties src) {
        Assert.isNull(src, "Properties must not be null.", new Object[0]);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Enumeration<?> en = src.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            result.put(name, src.getProperty(name));
        }
        return result;
    }

    public static Map<String, String> toMap(Properties src, String prefix) {
        LinkedHashMap<String, String> dest = new LinkedHashMap<String, String>();
        MapUtils.copyProperties(src, prefix, dest);
        return dest;
    }

    public static Map<String, String> toMap(Properties src, String substr, MatchMode matchMode) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        MapUtils.copyProperties(src, substr, matchMode, result);
        return result;
    }

    public static Properties toProperties(Map<String, String> map) {
        Assert.isNull(map, "Map must not be null.", new Object[0]);
        Properties prop = new Properties();
        for (Map.Entry<String, String> e : map.entrySet()) {
            prop.setProperty(e.getKey(), e.getValue());
        }
        return prop;
    }

    public static void copyProperties(Properties src, Properties dest) {
        Assert.isNull(src, "Properties must not be null.", new Object[0]);
        Enumeration<?> en = src.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            dest.setProperty(name, src.getProperty(name));
        }
    }

    public static void copyProperties(Properties src, String prefix, Properties dest) {
        Assert.isNull(src, "Properties must not be null.", new Object[0]);
        Enumeration<?> en = src.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!name.startsWith(prefix)) continue;
            dest.setProperty(name.substring(prefix.length() + 1), src.getProperty(name));
        }
    }

    public static void copyProperties(Properties src, String prefix, Map<String, String> dest) {
        Assert.isNull(src, "Properties must not be null.", new Object[0]);
        Enumeration<?> en = src.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!name.startsWith(prefix)) continue;
            dest.put(name.substring(prefix.length() + 1), src.getProperty(name));
        }
    }

    public static void copyProperties(Properties src, String substr, MatchMode matchMode, Properties dest) {
        Assert.isNull(src, "Properties must not be null.", new Object[0]);
        Enumeration<?> en = src.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (matchMode == null || !matchMode.matches(name, substr)) continue;
            String value = src.getProperty(name);
            dest.setProperty(name, value);
        }
    }

    public static void copyProperties(Properties src, String substr, MatchMode matchMode, Map<String, String> dest) {
        Assert.isNull(src, "Properties must not be null.", new Object[0]);
        Enumeration<?> en = src.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (matchMode == null || !matchMode.matches(name, substr)) continue;
            String value = src.getProperty(name);
            dest.put(name, value);
        }
    }

    public static <K> Map<K, String> toMatchedValueMap(Map<K, String> m, String substr, MatchMode matchMode) {
        LinkedHashMap result = new LinkedHashMap();
        MapUtils.copyValues(m, substr, matchMode, result);
        return result;
    }

    public static <V> Map<String, V> toMatchedKeyMap(Map<String, V> m, String substr, MatchMode matchMode) {
        LinkedHashMap result = new LinkedHashMap();
        MapUtils.copyKeys(m, substr, matchMode, result);
        return result;
    }

    public static <V> void copyKeys(Map<String, V> map, String substr, MatchMode matchMode, Map<String, V> target) {
        Assert.isNull(map, "Source map must not be null.", new Object[0]);
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String key = entry.getKey();
            if (matchMode == null || !matchMode.matches(key, substr)) continue;
            target.put(key, entry.getValue());
        }
    }

    public static <K> void copyValues(Map<K, String> map, String substr, MatchMode matchMode, Map<K, String> target) {
        Assert.isNull(map, "Source map must not be null.", new Object[0]);
        for (Map.Entry<K, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (matchMode == null || !matchMode.matches(value, substr)) continue;
            target.put(entry.getKey(), value);
        }
    }

    public static Map<String, String> populate(Object ... kwargs) {
        int i;
        Assert.isNull(kwargs);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int l = kwargs.length;
        for (i = 0; i < l; ++i) {
            if ((i & 1) != 1) continue;
            map.put(ObjectUtils.toString(kwargs[i - 1]), ObjectUtils.toString(kwargs[i]));
        }
        if ((i & 1) == 1) {
            map.put(ObjectUtils.toString(kwargs[i - 1]), null);
        }
        return map;
    }
}

