/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class MultiMapMap<K, N, V>
extends AbstractMap<K, Map<N, V>>
implements Map<K, Map<N, V>>,
Serializable {
    private static final long serialVersionUID = 1256299819433654455L;
    private final Map<K, Map<N, V>> delegate;

    public MultiMapMap() {
        this(new LinkedHashMap());
    }

    protected MultiMapMap(Map<K, Map<N, V>> delegate) {
        this.delegate = delegate;
    }

    public V get(K key, N name) {
        return this.get(key, name, null);
    }

    public V get(K key, N name, V defaultValue) {
        Map<N, V> map = this.delegate.get(key);
        V v = null;
        if (map != null) {
            v = map.get(name);
        }
        if (v == null) {
            v = defaultValue;
        }
        return v;
    }

    @Override
    public Map<N, V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Map<N, V> remove(Object key) {
        return this.delegate.remove(key);
    }

    public V removeValue(K key, N name) {
        Map<N, V> map = this.delegate.get(key);
        if (map != null) {
            return map.remove(name);
        }
        return null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public void clear(K key) {
        Map<N, V> map = this.delegate.get(key);
        if (map != null) {
            map.clear();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(K key, N name) {
        Map<N, V> map = this.delegate.get(key);
        if (map != null) {
            return map.containsKey(name);
        }
        return false;
    }

    public void append(K key, Map<N, V> value) {
        Map<N, V> map = this.delegate.get(key);
        if (map == null) {
            this.delegate.putIfAbsent(key, this.createValueMap());
            map = this.delegate.get(key);
        }
        map.putAll(value);
    }

    @Override
    public Map<N, V> put(K key, Map<N, V> value) {
        return this.delegate.put(key, value);
    }

    public V put(K key, N name, V value) {
        Map<N, V> map = this.delegate.get(key);
        if (map == null) {
            this.delegate.putIfAbsent(key, this.createValueMap());
            map = this.delegate.get(key);
        }
        return map.put(name, value);
    }

    protected Map<N, V> createValueMap() {
        return new LinkedHashMap();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int size(K key) {
        Map<N, V> map = this.delegate.get(key);
        return map != null ? map.size() : 0;
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Map.Entry<K, Map<N, V>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    public static <K, N, V> Map<K, Map<N, V>> synchronizedMap() {
        return new MultiMapMap<K, N, V>((Map)new ConcurrentHashMap()){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<N, V> createValueMap() {
                return new ConcurrentHashMap();
            }
        };
    }

    public static void main(String[] args) {
        MultiMapMap<String, String, String> map = new MultiMapMap<String, String, String>();
        for (int i = 0; i < 100; ++i) {
            map.put("Key_" + i, "Name_" + i, UUID.randomUUID().toString());
        }
        System.out.println(map);
    }
}

