/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.collection.ListUtils;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MultiValueMap<K, V>
extends AbstractMap<K, List<V>>
implements Map<K, List<V>>,
Serializable {
    private static final long serialVersionUID = 4293668328277273376L;
    private final Map<K, List<V>> delegate;

    public MultiValueMap() {
        this(new HashMap());
    }

    protected MultiValueMap(Map<K, List<V>> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public void clear(K key) {
        List<V> list = this.delegate.get(key);
        if (list != null) {
            list.clear();
        }
    }

    @Override
    public List<V> remove(Object key) {
        return this.delegate.remove(key);
    }

    public V remove(K key, int index) {
        List<V> list = this.delegate.get(key);
        return ListUtils.remove(list, index);
    }

    public V removeLast(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.removeLast(list);
    }

    public V removeFirst(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.removeFirst(list);
    }

    public V getFirst(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.getFirst(list);
    }

    public V getLast(K key) {
        List<V> list = this.delegate.get(key);
        return ListUtils.getLast(list);
    }

    public V get(K key, int index) {
        List<V> list = this.delegate.get(key);
        return ListUtils.get(list, index);
    }

    @Override
    public List<V> get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    public void removeValue(K key, V value) {
        List<V> list = this.delegate.get(key);
        if (list != null) {
            while (list.contains(value)) {
                list.remove(value);
            }
        }
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean containsValue(K key, V value) {
        List<V> list = this.delegate.get(key);
        return list != null ? list.contains(value) : false;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public Set<K> keys() {
        return this.delegate.keySet();
    }

    @Override
    public List<V> put(K key, List<V> value) {
        return this.delegate.put(key, value);
    }

    public void addAll(K key, Collection<V> values) {
        List<V> list = this.delegate.get(key);
        if (list == null) {
            this.delegate.putIfAbsent(key, this.createValueList());
            list = this.delegate.get(key);
        }
        list.addAll(values);
    }

    public V add(K key, V value) {
        List<V> list = this.delegate.get(key);
        if (list == null) {
            this.delegate.putIfAbsent(key, this.createValueList());
            list = this.delegate.get(key);
        }
        list.add(value);
        return value;
    }

    protected List<V> createValueList() {
        return new ArrayList();
    }

    public Map<K, V> toSingleValueMap() {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            map.put(entry.getKey(), ListUtils.getFirst(entry.getValue()));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> synchronizedMap() {
        return new MultiValueMap<K, V>((Map)new ConcurrentHashMap()){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<V> createValueList() {
                return new CopyOnWriteArrayList();
            }
        };
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

