/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.CaseFormat;
import com.github.paganini2008.devtools.CaseFormats;
import com.github.paganini2008.devtools.MissingKeyException;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.beans.BeanUtils;
import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.collection.KeyConversionMap;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.collection.Tuple;
import java.beans.PropertyDescriptor;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class TupleImpl
extends KeyConversionMap<String, String, Object>
implements Tuple {
    private static final long serialVersionUID = 507463156717310533L;
    private final CaseFormat caseFormat;

    public TupleImpl(CaseFormat format) {
        super(new LinkedHashMap());
        this.caseFormat = format;
    }

    @Override
    protected String convertKey(Object key) {
        String str;
        String string = str = key != null ? key.toString() : null;
        if (StringUtils.isNotBlank(str)) {
            str = this.caseFormat.toCase(str);
        }
        return str;
    }

    @Override
    public Object[] toValues() {
        return this.values().toArray();
    }

    @Override
    public String[] keys() {
        return this.keySet().toArray(new String[0]);
    }

    @Override
    public void set(String key, Object value) {
        super.put(key, value);
    }

    @Override
    public Object get(String key) {
        return super.get(key);
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, (String)null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, String.class, defaultValue);
    }

    @Override
    public <T> T getProperty(String key, Class<T> requiredType) {
        return this.getProperty(key, requiredType, null);
    }

    @Override
    public <T> T getProperty(String key, Class<T> requiredType, T defaultValue) {
        return MapUtils.get(this, key, requiredType, defaultValue);
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> requiredType) {
        T result = this.getProperty(key, requiredType);
        if (result == null) {
            throw new MissingKeyException(key);
        }
        return result;
    }

    @Override
    public <T> T toBean(Class<T> requiredType) {
        T object = BeanUtils.instantiate(requiredType, new Object[0]);
        this.fill(object);
        return object;
    }

    @Override
    public void fill(Object object) {
        Map<String, PropertyDescriptor> desc = PropertyUtils.getPropertyDescriptors(object.getClass());
        for (String key : desc.keySet()) {
            PropertyUtils.setProperty(object, key, this.get(key));
        }
    }

    @Override
    public void append(Map<String, Object> m) {
        if (m != null) {
            this.putAll(m);
        }
    }

    @Override
    public Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    public static void main(String[] args) {
        System.out.println(CaseFormats.LOWER_CAMEL.toCase("last_modified"));
        System.out.println(CaseFormats.UPPER_CAMEL.toCase("last_modified"));
        Tuple tuple = Tuple.newTuple(CaseFormats.LOWER_CAMEL);
        tuple.set("last_modified", new Date());
        System.out.println(tuple);
        System.out.println(tuple.getProperty("LastModified"));
    }
}

