/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.math.BigDecimalUtils;
import java.math.BigDecimal;

public class BigDecimaConverter
extends BasicConverter<BigDecimal> {
    private final Converter<Number, BigDecimal> numberConverter = new Converter<Number, BigDecimal>(){

        @Override
        public BigDecimal convertValue(Number source, BigDecimal defaultValue) {
            return BigDecimalUtils.valueOf(source, defaultValue);
        }
    };
    private final Converter<Boolean, BigDecimal> booleanConverter = new Converter<Boolean, BigDecimal>(){

        @Override
        public BigDecimal convertValue(Boolean source, BigDecimal defaultValue) {
            return BigDecimalUtils.valueOf(source, defaultValue);
        }
    };
    private final Converter<Character, BigDecimal> characterConverter = new Converter<Character, BigDecimal>(){

        @Override
        public BigDecimal convertValue(Character source, BigDecimal defaultValue) {
            return BigDecimalUtils.valueOf(source, defaultValue);
        }
    };
    private final Converter<String, BigDecimal> stringConverter = new Converter<String, BigDecimal>(){

        @Override
        public BigDecimal convertValue(String source, BigDecimal defaultValue) {
            return BigDecimalUtils.valueOf(source, defaultValue);
        }
    };

    public BigDecimaConverter() {
        this.registerType(Number.class, this.numberConverter);
        this.registerType(Character.class, this.characterConverter);
        this.registerType(Boolean.class, this.booleanConverter);
        this.registerType(String.class, this.stringConverter);
    }
}

