/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.math.BigIntegerUtils;
import java.math.BigInteger;

public class BigIntegerArrayConverter
extends BasicConverter<BigInteger[]> {
    private final Converter<byte[], BigInteger[]> byteArrayConverter = new Converter<byte[], BigInteger[]>(){

        @Override
        public BigInteger[] convertValue(byte[] source, BigInteger[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return BigIntegerUtils.valueOf(source);
        }
    };
    private final Converter<short[], BigInteger[]> shortArrayConverter = new Converter<short[], BigInteger[]>(){

        @Override
        public BigInteger[] convertValue(short[] source, BigInteger[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return BigIntegerUtils.valueOf(source);
        }
    };
    private final Converter<int[], BigInteger[]> intArrayConverter = new Converter<int[], BigInteger[]>(){

        @Override
        public BigInteger[] convertValue(int[] source, BigInteger[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return BigIntegerUtils.valueOf(source);
        }
    };
    private final Converter<long[], BigInteger[]> longArrayConverter = new Converter<long[], BigInteger[]>(){

        @Override
        public BigInteger[] convertValue(long[] source, BigInteger[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return BigIntegerUtils.valueOf(source);
        }
    };
    private final Converter<Number[], BigInteger[]> numberArrayConverter = new Converter<Number[], BigInteger[]>(){

        @Override
        public BigInteger[] convertValue(Number[] source, BigInteger[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return BigIntegerUtils.valueOf(source);
        }
    };
    private final Converter<String[], BigInteger[]> stringArrayConverter = new Converter<String[], BigInteger[]>(){

        @Override
        public BigInteger[] convertValue(String[] source, BigInteger[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return BigIntegerUtils.valueOf(source);
        }
    };

    public BigIntegerArrayConverter() {
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
    }
}

