/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.net.UrlUtils;
import com.github.paganini2008.devtools.primitives.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Blob;

public class ByteArrayConverter
extends BasicConverter<byte[]> {
    private final Converter<CharSequence, byte[]> charSequenceConverter = new Converter<CharSequence, byte[]>(){

        @Override
        public byte[] convertValue(CharSequence source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return source.toString().getBytes();
        }
    };
    private final Converter<short[], byte[]> shortArrayConverter = new Converter<short[], byte[]>(){

        @Override
        public byte[] convertValue(short[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<int[], byte[]> intArrayConverter = new Converter<int[], byte[]>(){

        @Override
        public byte[] convertValue(int[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<long[], byte[]> longArrayConverter = new Converter<long[], byte[]>(){

        @Override
        public byte[] convertValue(long[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<float[], byte[]> floatArrayConverter = new Converter<float[], byte[]>(){

        @Override
        public byte[] convertValue(float[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<double[], byte[]> doubleArrayConverter = new Converter<double[], byte[]>(){

        @Override
        public byte[] convertValue(double[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<char[], byte[]> charArrayConverter = new Converter<char[], byte[]>(){

        @Override
        public byte[] convertValue(char[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<boolean[], byte[]> booleanArrayConverter = new Converter<boolean[], byte[]>(){

        @Override
        public byte[] convertValue(boolean[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<Number[], byte[]> numberArrayConverter = new Converter<Number[], byte[]>(){

        @Override
        public byte[] convertValue(Number[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.casts(source);
        }
    };
    private final Converter<String[], byte[]> stringArrayConverter = new Converter<String[], byte[]>(){

        @Override
        public byte[] convertValue(String[] source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Bytes.parseMany(source);
        }
    };
    private final Converter<ByteBuffer, byte[]> byteBufferConverter = new Converter<ByteBuffer, byte[]>(){

        @Override
        public byte[] convertValue(ByteBuffer source, byte[] defaultValue) {
            return Bytes.toByteArray(source);
        }
    };
    private final Converter<URL, byte[]> urlConverter = new Converter<URL, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] convertValue(URL source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            InputStream in = null;
            try {
                in = UrlUtils.openStream(source);
                byte[] byArray = IOUtils.toByteArray(in);
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = defaultValue;
                return byArray;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
    };
    private final Converter<Blob, byte[]> blobConverter = new Converter<Blob, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] convertValue(Blob source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            InputStream in = null;
            try {
                in = source.getBinaryStream();
                byte[] byArray = IOUtils.toByteArray(in);
                return byArray;
            }
            catch (Exception e) {
                byte[] byArray = defaultValue;
                return byArray;
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
    };
    private final Converter<InputStream, byte[]> inputStreamConverter = new Converter<InputStream, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] convertValue(InputStream source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            try {
                byte[] byArray = IOUtils.toByteArray(source);
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = defaultValue;
                return byArray;
            }
            finally {
                IOUtils.closeQuietly(source);
            }
        }
    };
    private final Converter<Reader, byte[]> readerConverter = new Converter<Reader, byte[]>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] convertValue(Reader source, byte[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            try {
                byte[] byArray = IOUtils.toByteArray(source, ByteArrayConverter.this.charset);
                return byArray;
            }
            catch (IOException e) {
                byte[] byArray = defaultValue;
                return byArray;
            }
            finally {
                IOUtils.closeQuietly(source);
            }
        }
    };
    private Charset charset = CharsetUtils.DEFAULT;

    public ByteArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(InputStream.class, this.inputStreamConverter);
        this.registerType(Reader.class, this.readerConverter);
        this.registerType(URL.class, this.urlConverter);
        this.registerType(Blob.class, this.blobConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
        this.registerType(ByteBuffer.class, this.byteBufferConverter);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

