/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Doubles;
import java.util.List;

public class DoubleObjectArrayConverter
extends BasicConverter<Double[]> {
    private final Converter<CharSequence, Double[]> charSequenceConverter = new Converter<CharSequence, Double[]>(){

        @Override
        public Double[] convertValue(CharSequence source, Double[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, DoubleObjectArrayConverter.this.delimiter);
            return result != null ? Doubles.valueOf(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<Number[], Double[]> numberArrayConverter = new Converter<Number[], Double[]>(){

        @Override
        public Double[] convertValue(Number[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.valueOf(source);
        }
    };
    private final Converter<String[], Double[]> stringArrayConverter = new Converter<String[], Double[]>(){

        @Override
        public Double[] convertValue(String[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.valueOf(source);
        }
    };
    private final Converter<byte[], Double[]> byteArrayConverter = new Converter<byte[], Double[]>(){

        @Override
        public Double[] convertValue(byte[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private final Converter<short[], Double[]> shortArrayConverter = new Converter<short[], Double[]>(){

        @Override
        public Double[] convertValue(short[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private final Converter<char[], Double[]> charArrayConverter = new Converter<char[], Double[]>(){

        @Override
        public Double[] convertValue(char[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private final Converter<int[], Double[]> intArrayConverter = new Converter<int[], Double[]>(){

        @Override
        public Double[] convertValue(int[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private final Converter<long[], Double[]> longArrayConverter = new Converter<long[], Double[]>(){

        @Override
        public Double[] convertValue(long[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private final Converter<float[], Double[]> floatArrayConverter = new Converter<float[], Double[]>(){

        @Override
        public Double[] convertValue(float[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private final Converter<double[], Double[]> doubleArrayConverter = new Converter<double[], Double[]>(){

        @Override
        public Double[] convertValue(double[] source, Double[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Doubles.toWrappers(source);
        }
    };
    private String delimiter = ",";

    public DoubleObjectArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(short[].class, this.shortArrayConverter);
        this.registerType(int[].class, this.intArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }
}

