/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.converter;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.converter.BasicConverter;
import com.github.paganini2008.devtools.converter.Converter;
import com.github.paganini2008.devtools.primitives.Ints;
import java.util.List;

public class IntArrayConverter
extends BasicConverter<int[]> {
    private final Converter<CharSequence, int[]> charSequenceConverter = new Converter<CharSequence, int[]>(){

        @Override
        public int[] convertValue(CharSequence source, int[] defaultValue) {
            if (StringUtils.isBlank(source)) {
                return defaultValue;
            }
            List<String> result = StringUtils.split(source, ",");
            return result != null ? Ints.parseMany(result.toArray(new String[result.size()])) : defaultValue;
        }
    };
    private final Converter<String[], int[]> stringArrayConverter = new Converter<String[], int[]>(){

        @Override
        public int[] convertValue(String[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.parseMany(source);
        }
    };
    private final Converter<Number[], int[]> numberArrayConverter = new Converter<Number[], int[]>(){

        @Override
        public int[] convertValue(Number[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<char[], int[]> charArrayConverter = new Converter<char[], int[]>(){

        @Override
        public int[] convertValue(char[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<boolean[], int[]> booleanArrayConverter = new Converter<boolean[], int[]>(){

        @Override
        public int[] convertValue(boolean[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<byte[], int[]> byteArrayConverter = new Converter<byte[], int[]>(){

        @Override
        public int[] convertValue(byte[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<short[], int[]> shortArrayConverter = new Converter<short[], int[]>(){

        @Override
        public int[] convertValue(short[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<long[], int[]> longArrayConverter = new Converter<long[], int[]>(){

        @Override
        public int[] convertValue(long[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<float[], int[]> floatArrayConverter = new Converter<float[], int[]>(){

        @Override
        public int[] convertValue(float[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };
    private final Converter<double[], int[]> doubleArrayConverter = new Converter<double[], int[]>(){

        @Override
        public int[] convertValue(double[] source, int[] defaultValue) {
            if (source == null) {
                return defaultValue;
            }
            return Ints.casts(source);
        }
    };

    public IntArrayConverter() {
        this.registerType(CharSequence.class, this.charSequenceConverter);
        this.registerType(Number[].class, this.numberArrayConverter);
        this.registerType(String[].class, this.stringArrayConverter);
        this.registerType(char[].class, this.charArrayConverter);
        this.registerType(boolean[].class, this.booleanArrayConverter);
        this.registerType(byte[].class, this.byteArrayConverter);
        this.registerType(int[].class, this.shortArrayConverter);
        this.registerType(long[].class, this.longArrayConverter);
        this.registerType(float[].class, this.floatArrayConverter);
        this.registerType(double[].class, this.doubleArrayConverter);
    }
}

