/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.date;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.collection.LruMap;
import com.github.paganini2008.devtools.date.CalendarUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public abstract class DateUtils {
    public static final Date[] EMPTY_ARRAY = new Date[0];
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final SimpleDateFormat DEFAULT_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private static final LruMap<String, SimpleDateFormat> dateFormatterCache = new LruMap(16);

    public static DateFormat getDateFormatter(String datePattern) {
        Assert.hasNoText(datePattern, "Date pattern can not be blank.", new Object[0]);
        SimpleDateFormat sdf = dateFormatterCache.get(datePattern);
        if (sdf == null) {
            dateFormatterCache.put(datePattern, new SimpleDateFormat(datePattern, Locale.ENGLISH));
            sdf = dateFormatterCache.get(datePattern);
        }
        return sdf;
    }

    public static Date toDate(Long ms) {
        return DateUtils.toDate(ms, null);
    }

    public static Date toDate(Long ms, Date defaultValue) {
        return ms != null ? new Date(ms) : defaultValue;
    }

    public static Date toDate(Calendar calendar) {
        return DateUtils.toDate(calendar, null);
    }

    public static Date toDate(Calendar calendar, Date defaultValue) {
        return calendar != null ? calendar.getTime() : defaultValue;
    }

    public static Date toDate(LocalDate localDate, ZoneId zoneId) {
        return DateUtils.toDate(localDate, zoneId, null);
    }

    public static Date toDate(LocalDate localDate, ZoneId zoneId, Date defaultValue) {
        return localDate != null ? Date.from(localDate.atStartOfDay(zoneId).toInstant()) : defaultValue;
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId zoneId) {
        return DateUtils.toDate(localDateTime, zoneId, null);
    }

    public static Date toDate(LocalDateTime localDateTime, ZoneId zoneId, Date defaultValue) {
        return localDateTime != null ? Date.from(localDateTime.atZone(zoneId).toInstant()) : defaultValue;
    }

    public static Date[] toDateArray(long[] dates) {
        Date[] array = new Date[dates.length];
        int i = 0;
        for (long date : dates) {
            array[i++] = DateUtils.toDate(date);
        }
        return array;
    }

    public static Date[] toDateArray(Long[] mss) {
        return DateUtils.toDateArray(mss, null);
    }

    public static Date[] toDateArray(Long[] mss, Date defaultValue) {
        Date[] array = new Date[mss.length];
        int i = 0;
        for (Long ms : mss) {
            array[i++] = DateUtils.toDate(ms, defaultValue);
        }
        return array;
    }

    public static Date[] toDateArray(Calendar[] array) {
        return DateUtils.toDateArray(array, null);
    }

    public static Date[] toDateArray(Calendar[] array, Date defaultValue) {
        Date[] result = new Date[array.length];
        int i = 0;
        for (Calendar c : array) {
            result[i++] = DateUtils.toDate(c, defaultValue);
        }
        return result;
    }

    public static String format(Long ms, String datePattern) {
        return DateUtils.format(ms, datePattern, "");
    }

    public static String format(Long ms, String datePattern, String defaultValue) {
        return DateUtils.format(ms, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String format(Long ms) {
        return DateUtils.format(ms, (DateFormat)DEFAULT_DATE_FORMATTER);
    }

    public static String format(Long ms, DateFormat df) {
        return DateUtils.format(ms, df, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Long ms, DateFormat df, String defaultValue) {
        if (ms == null) {
            return defaultValue;
        }
        Assert.isNull(df, "DateFormat can not be null.", new Object[0]);
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            try {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return df.format(ms);
            }
            catch (RuntimeException e) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return defaultValue;
            }
        }
    }

    public static String format(Date date, String datePattern) {
        return DateUtils.format(date, datePattern, "");
    }

    public static String format(Date date, String datePattern, String defaultValue) {
        return DateUtils.format(date, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String format(Date date) {
        return DateUtils.format(date, (DateFormat)DEFAULT_DATE_FORMATTER);
    }

    public static String format(Date date, DateFormat df) {
        return DateUtils.format(date, df, "");
    }

    public static String format(Date date, DateFormat df, String defaultValue) {
        return DateUtils.format((Long)date.getTime(), df, defaultValue);
    }

    public static String[] formatMany(Date[] dates) {
        return DateUtils.formatMany(dates, DEFAULT_DATE_FORMATTER);
    }

    public static String[] formatMany(Date[] dates, DateFormat df) {
        return DateUtils.formatMany(dates, df, "");
    }

    public static String[] formatMany(Date[] dates, DateFormat df, String defaultValue) {
        Assert.isNull(dates, "Date array can not be null.", new Object[0]);
        String[] values = new String[dates.length];
        int i = 0;
        for (Date date : dates) {
            values[i++] = DateUtils.format(date, df, defaultValue);
        }
        return values;
    }

    public static String[] formatMany(Date[] dates, String datePattern) {
        return DateUtils.formatMany(dates, datePattern, "");
    }

    public static String[] formatMany(Date[] dates, String datePattern, String defaultValue) {
        return DateUtils.formatMany(dates, DateUtils.getDateFormatter(datePattern), defaultValue);
    }

    public static String reformat(String str, String srcFormat, String destFormat) {
        return DateUtils.reformat(str, srcFormat, destFormat, str);
    }

    public static String reformat(String str, String srcFormat, String destFormat, String defaultValue) {
        try {
            DateFormat leftSdf = DateUtils.getDateFormatter(srcFormat);
            Date date = leftSdf.parse(str);
            DateFormat rightSdf = DateUtils.getDateFormatter(destFormat);
            return rightSdf.format(date);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static Date parse(String str, String datePattern) {
        return DateUtils.parse(str, datePattern, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parse(String str, String datePattern, Date defaultValue) {
        DateFormat sdf = DateUtils.getDateFormatter(datePattern);
        Class<DateUtils> clazz = DateUtils.class;
        synchronized (DateUtils.class) {
            try {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return sdf.parse(str);
            }
            catch (ParseException e) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return defaultValue;
            }
        }
    }

    public static Date parse(String str, String[] datePatterns) {
        return DateUtils.parse(str, datePatterns, null);
    }

    public static Date parse(String str, String[] datePatterns, Date defaultValue) {
        Date date = null;
        for (String datePattern : datePatterns) {
            date = DateUtils.parse(str, datePattern, null);
            if (date == null) continue;
            return date;
        }
        return defaultValue;
    }

    public static Date addYears(Date date, int amount) {
        return DateUtils.addField(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.addField(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return DateUtils.addField(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.addField(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateUtils.addField(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.addField(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateUtils.addField(date, 13, amount);
    }

    private static Date addField(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null.");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date setYear(Date date, int amount) {
        return DateUtils.setField(date, 1, amount);
    }

    public static Date setMonth(Date date, int amount) {
        return DateUtils.setField(date, 2, amount);
    }

    public static Date setWeekOfYear(Date date, int amount) {
        return DateUtils.setField(date, 3, amount);
    }

    public static Date setWeekOfMonth(Date date, int amount) {
        return DateUtils.setField(date, 4, amount);
    }

    public static Date setDayOfWeek(Date date, int amount) {
        return DateUtils.setField(date, 7, amount);
    }

    public static Date setDay(Date date, int amount) {
        return DateUtils.setField(date, 5, amount);
    }

    public static Date setDayOfYear(Date date, int amount) {
        return DateUtils.setField(date, 6, amount);
    }

    public static Date setAM(Date date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(9, 0);
        c.set(10, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date setPM(Date date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(9, 1);
        c.set(10, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date setTime(Date date, int hourOfDay, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    private static Date setField(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(calendarField, amount);
        return c.getTime();
    }

    public static Long getTimeInMillis(Date date) {
        return DateUtils.getTimeInMillis(date, null);
    }

    public static Long getTimeInMillis(Date date, Long defaultValue) {
        return date != null ? date.getTime() : defaultValue.longValue();
    }

    public static Long[] getTimeInMillis(Date[] dates) {
        return DateUtils.getTimeInMillis(dates, null);
    }

    public static Long[] getTimeInMillis(Date[] dates, Long defaultValue) {
        Assert.isNull(dates, "Date string array must not be null.", new Object[0]);
        Long[] values = new Long[dates.length];
        int i = 0;
        for (Date date : dates) {
            values[i++] = DateUtils.getTimeInMillis(date, defaultValue);
        }
        return values;
    }

    public static Date valueOf(int year, int month, int date) {
        return DateUtils.valueOf(year, month, date, 0, 0, 0);
    }

    public static Date valueOf(int year, int month, int date, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, date, hour, minute, second);
        return c.getTime();
    }

    public static Date valueOf(long time, int hour, int minute, int second) {
        Calendar c = CalendarUtils.valueOf(time, hour, minute, second);
        return c.getTime();
    }

    public static Date setTime(int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        return c.getTime();
    }

    public static Date[] parseMany(String[] strings, String[] datePatterns) {
        return DateUtils.parseMany(strings, datePatterns, null);
    }

    public static Date[] parseMany(String[] strings, String[] datePatterns, Date defaultValue) {
        Assert.isNull(strings, "String array can not be null.", new Object[0]);
        Date[] result = new Date[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = DateUtils.parse(str, datePatterns, defaultValue);
        }
        return result;
    }

    public static int getYear() {
        return DateUtils.getYear(new Date());
    }

    public static int getYear(Date date) {
        return DateUtils.getField(date, 1);
    }

    public static int getMonth() {
        return DateUtils.getMonth(new Date());
    }

    public static int getMonth(Date date) {
        return DateUtils.getField(date, 2);
    }

    public static int getDate() {
        return DateUtils.getDate(new Date());
    }

    public static int getDate(Date date) {
        return DateUtils.getField(date, 5);
    }

    public static int getWeekOfMonth() {
        return DateUtils.getWeekOfMonth(new Date());
    }

    public static int getWeekOfMonth(Date date) {
        return DateUtils.getField(date, 4);
    }

    public static int getHourOfDay() {
        return DateUtils.getHourOfDay(new Date());
    }

    public static int getHourOfDay(Date date) {
        return DateUtils.getField(date, 11);
    }

    public static int getMinute() {
        return DateUtils.getMinute(new Date());
    }

    public static int getMinute(Date date) {
        return DateUtils.getField(date, 12);
    }

    public static int getSecond() {
        return DateUtils.getSecond(new Date());
    }

    public static int getSecond(Date date) {
        return DateUtils.getField(date, 13);
    }

    public static int getField(Date date, int calendarField) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(calendarField);
    }

    public static long converToSecond(long interval, TimeUnit timeUnit) {
        return timeUnit != TimeUnit.SECONDS ? TimeUnit.SECONDS.convert(interval, timeUnit) : interval;
    }

    public static long convertToMillis(long interval, TimeUnit timeUnit) {
        return timeUnit != TimeUnit.MILLISECONDS ? TimeUnit.MILLISECONDS.convert(interval, timeUnit) : interval;
    }

    public static long convertToNanos(long interval, TimeUnit timeUnit) {
        return timeUnit != TimeUnit.NANOSECONDS ? TimeUnit.NANOSECONDS.convert(interval, timeUnit) : interval;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtils.getWeekOfMonth());
    }
}

