/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.event;

import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.event.Event;
import com.github.paganini2008.devtools.event.EventPubSub;
import com.github.paganini2008.devtools.event.EventSubscriber;
import com.github.paganini2008.devtools.multithreads.Producer;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;

public class EventBus<E extends Event<T>, T>
implements EventPubSub<E, T> {
    private EventHandler<E, T> delegate;

    public EventBus(int nThreads, boolean multicast) {
        this(ThreadUtils.commonPool(nThreads), multicast);
    }

    public EventBus(ThreadPool threadPool, boolean multicast) {
        this.delegate = new EventHandler(threadPool, multicast);
    }

    @Override
    public void publish(E event) {
        this.delegate.publish(event);
    }

    @Override
    public void subscribe(EventSubscriber<E, T> subscriber) {
        this.delegate.subscribe(subscriber);
    }

    @Override
    public void unsubscribe(EventSubscriber<E, T> subscriber) {
        this.delegate.unsubscribe(subscriber);
    }

    public void close() {
        this.delegate.producer.join();
    }

    private static Class<?> findParameterizedType(Class<?> implementation) {
        List<ParameterizedType> parameterizedTypes = ClassUtils.getAllParameterizedTypes(implementation);
        for (ParameterizedType parameterizedType : parameterizedTypes) {
            if (parameterizedType.getRawType() != EventSubscriber.class) continue;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        throw new IllegalStateException(implementation.getName());
    }

    static class EventGroup<E extends Event<T>, T>
    implements EventSubscriber<E, T> {
        final Producer<Runnable, Object> producer;
        final BlockingQueue<EventSubscriber<E, T>> q;
        final boolean multicast;

        EventGroup(Producer<Runnable, Object> producer, boolean multicast) {
            this.producer = producer;
            this.multicast = multicast;
            this.q = new PriorityBlockingQueue<EventSubscriber<E, T>>();
        }

        @Override
        public void onEventFired(E event) {
            if (this.multicast) {
                this.q.forEach(subscriber -> this.producer.produce(() -> subscriber.onEventFired(event)));
            } else {
                ArrayList list = new ArrayList();
                int elements = this.q.drainTo(list);
                if (elements > 0) {
                    list.forEach(subscriber -> this.producer.produce(() -> subscriber.onEventFired(event)));
                }
            }
        }
    }

    static class EventHandler<E extends Event<T>, T>
    implements Producer.Consumer<Runnable, Object>,
    EventPubSub<E, T> {
        final Producer<Runnable, Object> producer;
        final boolean multicast;
        final ConcurrentMap<Class<?>, EventGroup> eventGroups = new ConcurrentHashMap();

        EventHandler(ThreadPool threadPool, boolean multicast) {
            this.producer = new Producer<Runnable, Object>(threadPool, this);
            this.multicast = multicast;
        }

        @Override
        public void publish(E event) {
            if (this.eventGroups.containsKey(event.getClass())) {
                ((EventGroup)this.eventGroups.get(event.getClass())).onEventFired(event);
            }
        }

        @Override
        public void subscribe(EventSubscriber<E, T> subscriber) {
            BlockingQueue q;
            Class eventClass = EventBus.findParameterizedType(subscriber.getClass());
            EventGroup eventGroup = (EventGroup)this.eventGroups.get(eventClass);
            if (eventGroup == null) {
                this.eventGroups.putIfAbsent(eventClass, new EventGroup(this.producer, this.multicast));
                eventGroup = (EventGroup)this.eventGroups.get(eventClass);
            }
            if (eventGroup != null && !(q = eventGroup.q).contains(subscriber)) {
                q.offer(subscriber);
            }
        }

        @Override
        public void unsubscribe(EventSubscriber<E, T> subscriber) {
            Class eventClass = EventBus.findParameterizedType(subscriber.getClass());
            if (this.eventGroups.containsKey(eventClass)) {
                EventGroup eventGroup = (EventGroup)this.eventGroups.get(eventClass);
                eventGroup.q.remove(subscriber);
            }
        }

        @Override
        public Object consume(Runnable action) {
            action.run();
            return null;
        }

        public void onRejection(Runnable action) {
            action.run();
        }
    }
}

