/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.event;

import com.github.paganini2008.devtools.event.Event;
import com.github.paganini2008.devtools.event.EventBus;
import com.github.paganini2008.devtools.event.EventSubscriber;
import java.util.concurrent.atomic.AtomicInteger;

public class TestMain {
    private static final AtomicInteger counter = new AtomicInteger();

    public static void main(String[] args) throws Exception {
        int i;
        EventBus<TestEvent, String> eventBus = new EventBus<TestEvent, String>(10, true);
        for (i = 0; i < 2; ++i) {
            eventBus.subscribe(new TestSubcriber("Name_" + i));
        }
        for (i = 0; i < 100000; ++i) {
            eventBus.publish(new TestEvent((Object)eventBus, String.valueOf(i)));
        }
        System.in.read();
        eventBus.close();
        System.out.println("TestMain.main(): " + counter);
    }

    public static class TestSubcriber
    implements EventSubscriber<TestEvent, String> {
        private final String name;

        public TestSubcriber(String name) {
            this.name = name;
        }

        @Override
        public void onEventFired(TestEvent event) {
            System.out.println("Name: " + this.name + ", Value: " + (String)event.getArgument());
            counter.incrementAndGet();
        }
    }

    public static class TestEvent
    extends Event<String> {
        private static final long serialVersionUID = 1L;

        public TestEvent(Object source, String msg) {
            super(source, msg);
        }
    }
}

