/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.http;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.http.BasicNameValuePair;
import com.github.paganini2008.devtools.http.HttpBaseImpl;
import com.github.paganini2008.devtools.http.HttpRequest;
import com.github.paganini2008.devtools.http.NameValuePair;
import com.github.paganini2008.devtools.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HttpRequestImpl
extends HttpBaseImpl<HttpRequest>
implements HttpRequest {
    private static final long serialVersionUID = -1294872498012012776L;
    private int connectTimeoutMillis = 60000;
    private int readTimeoutMillis = 60000;
    private boolean followRedirects = false;
    private boolean doOutput;
    private List<NameValuePair> data = new ArrayList<NameValuePair>();
    private boolean ignoreHttpErrors = false;
    private boolean ignoreContentType = false;
    private boolean validateTSLCertificates = false;
    private boolean retryRequestsIfError = false;
    private String baseUrl;
    private int maxBodySizeBytes = 0x100000;
    private SocketAddress proxy;
    private int maxRequests;
    private int maxRedirects;

    HttpRequestImpl() {
        this.headers.put("Accept-Encoding", "gzip");
        this.maxRequests = 3;
        this.maxRedirects = 10;
    }

    @Override
    public int maxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public HttpRequest maxRedirects(int redirects) {
        this.maxRedirects = redirects;
        return this;
    }

    @Override
    public int maxRequests() {
        return this.maxRequests;
    }

    @Override
    public HttpRequest maxRequests(int requests) {
        this.maxRequests = requests;
        return this;
    }

    @Override
    public boolean validateTLSCertificates() {
        return this.validateTSLCertificates;
    }

    @Override
    public HttpRequest validateTLSCertificates(boolean value) {
        this.validateTSLCertificates = value;
        return this;
    }

    @Override
    public boolean followRedirects() {
        return this.followRedirects;
    }

    @Override
    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public HttpRequest doOutput(boolean value) {
        this.doOutput = value;
        return this;
    }

    @Override
    public boolean doOutput() {
        return this.doOutput;
    }

    @Override
    public int readTimeout() {
        return this.readTimeoutMillis;
    }

    @Override
    public HttpRequest readTimeout(int millis) {
        Assert.isFalse(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater", new Object[0]);
        this.readTimeoutMillis = millis;
        return this;
    }

    @Override
    public int connectTimeout() {
        return this.connectTimeoutMillis;
    }

    @Override
    public HttpRequest connectTimeout(int millis) {
        Assert.isFalse(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater", new Object[0]);
        this.connectTimeoutMillis = millis;
        return this;
    }

    @Override
    public boolean ignoreHttpErrors() {
        return this.ignoreHttpErrors;
    }

    @Override
    public HttpRequest ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.ignoreHttpErrors = ignoreHttpErrors;
        return this;
    }

    @Override
    public boolean ignoreContentType() {
        return this.ignoreContentType;
    }

    @Override
    public HttpRequest ignoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
        return this;
    }

    @Override
    public HttpRequest data(Map<String, String> data) {
        if (data != null) {
            for (Map.Entry<String, String> entry : data.entrySet()) {
                this.data(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    @Override
    public HttpRequest data(String name, String value) {
        return this.data(new BasicNameValuePair().name(name).value(value));
    }

    public HttpRequest data(String name, String value, File file) {
        try {
            return this.data(name, value, FileUtils.openInputStream(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public HttpRequest data(String name, String value, InputStream inputStream) {
        return this.data(new BasicNameValuePair().name(name).value(value).inputStream(inputStream));
    }

    @Override
    public HttpRequest data(Collection<NameValuePair> data) {
        if (data != null) {
            for (NameValuePair entry : data) {
                this.data(entry);
            }
        }
        return this;
    }

    @Override
    public HttpRequest data(NameValuePair nameValue) {
        Assert.isNull(nameValue, "NameValue must not be null.", new Object[0]);
        this.data.add(nameValue);
        return this;
    }

    @Override
    public List<NameValuePair> data() {
        return this.data;
    }

    @Override
    public int maxBodySize() {
        return this.maxBodySizeBytes;
    }

    @Override
    public HttpRequest maxBodySize(int bytes) {
        this.maxBodySizeBytes = bytes;
        return this;
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public HttpRequest baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public SocketAddress proxy() {
        return this.proxy;
    }

    @Override
    public HttpRequest proxy(String hostname, int port) {
        this.proxy = new InetSocketAddress(hostname, port);
        return this;
    }

    @Override
    public boolean retryRequestsIfError() {
        return this.retryRequestsIfError;
    }

    @Override
    public HttpRequest retryRequestsIfError(boolean retryRequests) {
        this.retryRequestsIfError = retryRequests;
        return this;
    }
}

