/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.RandomStringUtils;
import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.collection.LruQueue;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.nio.ByteBuffer;

public class BufferPool {
    private final LruQueue<ByteBuffer> queue;

    public BufferPool(int maxSize) {
        this.queue = new LruQueue(maxSize);
    }

    public ByteBuffer poll(int capacity) {
        ByteBuffer buffer = this.queue.poll();
        if (buffer == null) {
            buffer = ByteBuffer.allocate(capacity);
        } else if (buffer.capacity() < capacity) {
            this.queue.offer(buffer);
            buffer = ByteBuffer.allocate(capacity);
        }
        buffer.clear();
        buffer.limit(capacity);
        return buffer;
    }

    public void offer(ByteBuffer buffer) {
        this.queue.offer(buffer);
    }

    public int size() {
        return this.queue.size();
    }

    public static void main(String[] args) throws Exception {
        BufferPool bufferPool = new BufferPool(128);
        ThreadUtils.loop(8, 100, i -> {
            String str = RandomStringUtils.randomString(RandomUtils.randomInt(100, 10000));
            byte[] data = str.getBytes();
            ByteBuffer buffer = bufferPool.poll(data.length);
            buffer.put(data);
            buffer.flip();
            data = new byte[data.length];
            buffer.get(data);
            System.out.println("Answer: " + new String(data).equals(str));
            bufferPool.offer(buffer);
        });
    }
}

