/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.FileInfo;
import com.github.paganini2008.devtools.io.Progressable;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.primitives.Floats;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class EnhancedDirectoryWalker {
    private final File directory;
    private final int maxDepth;
    private final FileFilter fileFilter;

    public EnhancedDirectoryWalker(File directory, int maxDepth, FileFilter fileFilter) {
        this.directory = directory;
        this.maxDepth = maxDepth;
        this.fileFilter = fileFilter;
    }

    public final FileInfo walk(int nThreads, Progressable progressable) throws Exception {
        RootInfo rootInfo = new RootInfo(this.directory);
        FileInfoImpl fileInfo = new FileInfoImpl(this.directory, 0, rootInfo);
        ForkJoinPool pool = this.getThreadPool(nThreads);
        ConcurrentHashMap context = new ConcurrentHashMap();
        ThreadUtils.runAsThread(() -> {
            try {
                DirectoryWalkTask task = new DirectoryWalkTask(fileInfo, context);
                ForkJoinTask<EnhancedFileInfo> future = pool.submit(task);
                future.get();
            }
            catch (Exception e) {
                this.handleDirectoryIfError(this.directory, fileInfo, e);
            }
            finally {
                ThreadUtils.notify(rootInfo, () -> rootInfo.isFinished());
                ExecutorUtils.gracefulShutdown(pool, 60000L);
            }
        });
        if (progressable != null) {
            ThreadUtils.scheduleAtFixedRate(() -> {
                progressable.progress(rootInfo.getFileCount(), rootInfo.getFolderCount(), rootInfo.getLength(), rootInfo.getCompletedRatio(), rootInfo.getElapsed());
                return !rootInfo.isFinished();
            }, 1L, TimeUnit.SECONDS);
        }
        ThreadUtils.wait(rootInfo, () -> rootInfo.isFinished());
        return fileInfo;
    }

    protected ForkJoinPool getThreadPool(int nThreads) {
        return new ForkJoinPool(nThreads);
    }

    protected void enterDirectory(File directory, FileInfo fileInfo) throws Exception {
    }

    protected void leaveDirectory(File directory, FileInfo fileInfo) throws Exception {
    }

    protected boolean shouldHandleDirectory(File directory, FileInfo fileInfo) throws Exception {
        return true;
    }

    protected boolean shouldHandleFile(File file, FileInfo fileInfo) throws Exception {
        return true;
    }

    protected void handleFile(File file, FileInfo fileInfo) throws Exception {
    }

    protected void handleFileIfError(File file, FileInfo fileInfo, Exception cause) {
    }

    protected void handleDirectoryIfError(File file, FileInfo fileInfo, Exception cause) {
    }

    public static void main(String[] args) throws Exception {
        File directory = new File("D:\\work\\gitlab_0613");
        EnhancedDirectoryWalker walker = new EnhancedDirectoryWalker(directory, -1, null);
        FileInfo fileInfo = walker.walk(10, new Progressable(){

            @Override
            public void progress(int fileCount, int folderCount, long length, float completedRatio, long elapsed) {
                System.out.println("fileCount: " + fileCount + ", folderCount: " + folderCount + ", length: " + length + ", completedRatio: " + completedRatio + ", elapsed: " + elapsed);
            }
        });
        System.out.println(fileInfo.getElapsed());
        System.out.println(fileInfo);
        System.in.read();
        System.out.println("Completed.");
    }

    class DirectoryWalkTask
    extends RecursiveTask<EnhancedFileInfo> {
        private static final long serialVersionUID = -1911846799071310358L;
        private final FileInfoImpl fileInfo;
        private final Map<String, Object> context;

        DirectoryWalkTask(FileInfoImpl fileInfo, Map<String, Object> context) {
            this.fileInfo = fileInfo;
            this.context = context;
        }

        @Override
        protected EnhancedFileInfo compute() {
            File directory = this.fileInfo.getFile();
            try {
                if (EnhancedDirectoryWalker.this.shouldHandleDirectory(directory, this.fileInfo)) {
                    EnhancedDirectoryWalker.this.enterDirectory(directory, this.fileInfo);
                    int childDepth = this.fileInfo.getDepth();
                    if (EnhancedDirectoryWalker.this.maxDepth < 0 || childDepth <= EnhancedDirectoryWalker.this.maxDepth) {
                        File[] childFiles;
                        File[] fileArray = childFiles = EnhancedDirectoryWalker.this.fileFilter != null ? directory.listFiles(EnhancedDirectoryWalker.this.fileFilter) : directory.listFiles();
                        if (childFiles != null) {
                            for (File childFile : childFiles) {
                                if (childFile.isDirectory()) {
                                    this.fileInfo.countFolders();
                                    DirectoryWalkTask task = new DirectoryWalkTask(new FileInfoImpl(childFile, childDepth + 1, (RootInfo)this.fileInfo.getRootInfo()), this.context);
                                    task.fork();
                                    EnhancedFileInfo childInfo = (EnhancedFileInfo)task.join();
                                    this.fileInfo.childs.add(childInfo);
                                    continue;
                                }
                                if (!EnhancedDirectoryWalker.this.shouldHandleFile(childFile, this.fileInfo)) continue;
                                this.fileInfo.countFiles();
                                this.fileInfo.setLength(childFile.length());
                                try {
                                    EnhancedDirectoryWalker.this.handleFile(childFile, this.fileInfo);
                                }
                                catch (Exception e) {
                                    EnhancedDirectoryWalker.this.handleFileIfError(childFile, this.fileInfo, e);
                                }
                            }
                        }
                    }
                }
                EnhancedDirectoryWalker.this.leaveDirectory(directory, this.fileInfo);
            }
            catch (Exception e) {
                EnhancedDirectoryWalker.this.handleDirectoryIfError(directory, this.fileInfo, e);
            }
            this.fileInfo.finish(directory);
            return this.fileInfo;
        }
    }

    static class FileInfoImpl
    implements EnhancedFileInfo {
        final AtomicInteger fileCount = new AtomicInteger(0);
        final AtomicInteger folderCount = new AtomicInteger(0);
        final AtomicLong length = new AtomicLong(0L);
        final List<EnhancedFileInfo> childs = new ArrayList<EnhancedFileInfo>();
        final File directory;
        final int depth;
        final long startTime;
        final RootInfo rootInfo;
        final AtomicBoolean finished = new AtomicBoolean(false);
        long elapsed;

        FileInfoImpl(File directory, int depth, RootInfo rootInfo) {
            this.directory = directory;
            this.depth = depth;
            this.rootInfo = rootInfo;
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public File getFile() {
            return this.directory;
        }

        void countFiles() {
            this.fileCount.incrementAndGet();
            this.rootInfo.fileCount.incrementAndGet();
        }

        void countFolders() {
            this.folderCount.incrementAndGet();
            this.rootInfo.folderCount.incrementAndGet();
        }

        void setLength(long length) {
            this.length.addAndGet(length);
            this.rootInfo.length.addAndGet(length);
        }

        @Override
        public int getFileCount(boolean recursive) {
            int total = this.fileCount.get();
            if (recursive) {
                for (EnhancedFileInfo fileInfo : this.childs) {
                    total += fileInfo.getFileCount(recursive);
                }
            }
            return total;
        }

        @Override
        public int getFolderCount(boolean recursive) {
            int total = this.folderCount.get();
            if (recursive) {
                for (EnhancedFileInfo fileInfo : this.childs) {
                    total += fileInfo.getFolderCount(recursive);
                }
            }
            return total;
        }

        @Override
        public long getLength(boolean recursive) {
            long total = this.length.get();
            for (EnhancedFileInfo fileInfo : this.childs) {
                total += fileInfo.getLength(recursive);
            }
            return total;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public long getElapsed() {
            return this.finished.get() ? this.elapsed : (this.elapsed = System.currentTimeMillis() - this.startTime);
        }

        @Override
        public FileInfo getRootInfo() {
            return this.rootInfo;
        }

        @Override
        public boolean isFinished() {
            return this.finished.get();
        }

        @Override
        public float getCompletedRatio() {
            return this.rootInfo.getCompletedRatio();
        }

        void finish(File file) {
            this.rootInfo.files.remove(file);
            this.finished.set(true);
        }
    }

    static class RootInfo
    implements FileInfo {
        final AtomicInteger fileCount = new AtomicInteger(0);
        final AtomicInteger folderCount = new AtomicInteger(0);
        final AtomicLong length = new AtomicLong(0L);
        final long startTime;
        final File directory;
        final List<File> files = new CopyOnWriteArrayList<File>();
        final int fileSize;
        volatile long elapsed;

        RootInfo(File directory) {
            this.directory = directory;
            this.files.addAll(Arrays.asList(directory.listFiles(file -> file.isDirectory())));
            this.fileSize = this.files.size();
            this.startTime = System.currentTimeMillis();
        }

        @Override
        public File getFile() {
            return this.directory;
        }

        @Override
        public int getFileCount() {
            return this.fileCount.get();
        }

        @Override
        public int getFolderCount() {
            return this.folderCount.get();
        }

        @Override
        public long getLength() {
            return this.length.get();
        }

        @Override
        public long getElapsed() {
            return this.files.isEmpty() ? this.elapsed : (this.elapsed = System.currentTimeMillis() - this.startTime);
        }

        @Override
        public boolean isFinished() {
            return this.files.isEmpty();
        }

        @Override
        public float getCompletedRatio() {
            System.out.println("fileSize: " + this.fileSize + ", files.size(): " + this.files.size());
            float value = (float)(this.fileSize - this.files.size()) / (float)this.fileSize;
            return Floats.toFixed(value, 3);
        }
    }

    public static interface EnhancedFileInfo
    extends FileInfo {
        @Override
        default public int getFileCount() {
            return this.getFileCount(false);
        }

        @Override
        default public int getFolderCount() {
            return this.getFolderCount(false);
        }

        @Override
        default public long getLength() {
            return this.getLength(false);
        }

        public int getFileCount(boolean var1);

        public int getFolderCount(boolean var1);

        public long getLength(boolean var1);

        public int getDepth();

        public FileInfo getRootInfo();
    }
}

