/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.Assert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FileAssert {
    private FileAssert() {
    }

    public static void isFile(File arg) throws IOException {
        FileAssert.isFile(arg, "File '" + arg + "' is existed but is a file.");
    }

    public static void isFile(File arg, String msg) throws IOException {
        Assert.isTrue(arg != null && arg.exists() && arg.isFile(), new IOException(msg));
    }

    public static void isDirectory(File arg) throws IOException {
        FileAssert.isDirectory(arg, "File '" + arg + "' is existed but is a directory.");
    }

    public static void isDirectory(File arg, String msg) throws IOException {
        Assert.isTrue(arg != null && arg.exists() && arg.isDirectory(), new IOException(msg));
    }

    public static void existed(File arg) throws IOException {
        FileAssert.existed(arg, "File '" + arg + "' is already existed.");
    }

    public static void existed(File arg, String msg) throws IOException {
        Assert.isTrue(arg != null && arg.exists(), new IOException(msg));
    }

    public static void notExisted(File arg) throws FileNotFoundException {
        FileAssert.notExisted(arg, "File '" + arg + "' is not existed.");
    }

    public static void notExisted(File arg, String msg) throws FileNotFoundException {
        Assert.isFalse(arg != null && arg.exists(), new FileNotFoundException(msg));
    }

    public static void cannotWrite(File arg) throws IOException {
        FileAssert.cannotWrite(arg, "File '" + arg + "' can not write.");
    }

    public static void cannotWrite(File arg, String msg) throws IOException {
        Assert.isFalse(arg != null && arg.exists() && arg.canWrite(), new IOException(msg));
    }

    public static void cannotRead(File arg) throws IOException {
        FileAssert.cannotRead(arg, "File '" + arg + "' can not read.");
    }

    public static void cannotRead(File arg, String msg) throws IOException {
        Assert.isFalse(arg != null && arg.exists() && arg.canRead(), new IOException(msg));
    }
}

