/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.io.FileWatchdog;
import com.github.paganini2008.devtools.io.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class FileTracker
implements FileWatcher {
    private static final int SKIP_LINE_BEGIN = System.getProperty("line.separator").length();
    private final FileWatchdog watchdog;
    private final Map<File, RandomAccessFile> objects = new HashMap<File, RandomAccessFile>();
    private final Map<File, Long> pointers = new HashMap<File, Long>();
    private Charset charset = CharsetUtils.UTF_8;

    public FileTracker(File ... files) {
        this.watchdog = new FileWatchdog(files);
        this.watchdog.addWatcher(this);
        this.refresh(files);
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void watch(int interval) {
        this.watchdog.setInterval(interval);
        this.watchdog.start();
    }

    public void cancel() {
        this.watchdog.stop();
    }

    private void refresh(File[] files) {
        for (File file : files) {
            if (!file.exists()) continue;
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                this.objects.put(file, raf);
                this.pointers.put(file, raf.length());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public synchronized void onCreate(File file) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            this.objects.put(file, raf);
            this.pointers.put(file, 0L);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void onDelete(File file) {
        this.objects.remove(file);
        this.pointers.remove(file);
    }

    @Override
    public synchronized void onUpdate(File file) {
        RandomAccessFile raf = this.objects.get(file);
        long pointer = this.pointers.get(file);
        try {
            raf.seek(pointer + (long)SKIP_LINE_BEGIN);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            String line;
            while (null != (line = raf.readLine())) {
                this.handleLine(file, new String(line.getBytes("ISO-8859-1"), this.charset));
            }
            this.pointers.put(file, raf.getFilePointer());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void handleLine(File file, String line) {
    }

    public static void main(String[] args) throws Exception {
        FileTracker tail = new FileTracker(new File[]{new File("d:/sql/solr.txt")}){

            @Override
            protected void handleLine(File file, String line) {
                System.out.println("Line: " + line);
            }
        };
        tail.watch(500);
        System.in.read();
        tail.cancel();
        System.out.println("FileTracker.main()");
    }
}

