/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.io.FileWatcher;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileWatchdog
extends TimerTask {
    private static final int STATE_NONE = 0;
    private static final int STATE_CREATE = 1;
    private static final int STATE_DELETE = 2;
    private static final int STATE_UPDATE = 3;
    private static final long DEFAULT_CHECKED_INTERVAL = 3000L;
    private final List<FileWatcher> watchers = new CopyOnWriteArrayList<FileWatcher>();
    private final List<FileEntry> fileEntries = new CopyOnWriteArrayList<FileEntry>();
    private Timer timer;
    private long interval = 3000L;
    private volatile boolean running = false;

    public FileWatchdog(File ... files) {
        this.addFiles(files);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setInterval(long interval) {
        if (interval > 3000L) {
            this.interval = interval;
        }
    }

    public void addFiles(File ... files) {
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                this.fileEntries.add(new FileEntry(files[i]));
            }
        }
    }

    public void addWatcher(FileWatcher fileWatcher) {
        if (fileWatcher != null) {
            this.watchers.add(fileWatcher);
        }
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("FileWatchdog is running now.");
        }
        this.timer = new Timer("FileWatchdog@" + System.currentTimeMillis(), false);
        this.timer.schedule((TimerTask)this, this.interval, this.interval);
        this.running = true;
    }

    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("FileWatchdog is not running.");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.running = false;
    }

    @Override
    public void run() {
        block7: for (FileEntry fileEntry : this.fileEntries) {
            try {
                switch (fileEntry.changed()) {
                    case 1: {
                        for (FileWatcher watcher : this.watchers) {
                            watcher.onCreate(fileEntry.getFile());
                        }
                        continue block7;
                    }
                    case 2: {
                        for (FileWatcher watcher : this.watchers) {
                            watcher.onDelete(fileEntry.getFile());
                        }
                        continue block7;
                    }
                    case 3: {
                        for (FileWatcher watcher : this.watchers) {
                            watcher.onUpdate(fileEntry.getFile());
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                if (this.onError(fileEntry.getFile(), e)) continue;
                break;
            }
        }
    }

    protected boolean onError(File file, IOException e) {
        return true;
    }

    static class FileEntry {
        final File file;
        boolean exists;
        long length;
        long lastModified;

        FileEntry(File file) {
            this.exists = file.exists();
            this.length = this.exists ? file.length() : 0L;
            this.lastModified = this.exists ? file.lastModified() : 0L;
            this.file = file;
        }

        public int changed() {
            boolean otherExists = this.exists;
            this.exists = this.file.exists();
            long otherLastModified = this.lastModified;
            this.lastModified = this.file.lastModified();
            long otherLength = this.length;
            this.length = this.file.length();
            if (!otherExists && this.exists) {
                return 1;
            }
            if (otherExists && !this.exists) {
                return 2;
            }
            return otherLength != this.length || this.lastModified > otherLastModified ? 3 : 0;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isExists() {
            return this.exists;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String toString() {
            return "FileEntry [file=" + this.file + ", exists=" + this.exists + ", length=" + this.length + ", lastModified=" + this.lastModified + "]";
        }
    }
}

