/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.CharsetUtils;
import com.github.paganini2008.devtools.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    public static final int DEFAULT_BYTE_BUFFER_SIZE = 4096;
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 4096;
    public static final int EOF = -1;
    public static final String NEWLINE = System.getProperty("line.separator");

    private IOUtils() {
    }

    public static void write(byte[] content, OutputStream output) throws IOException {
        Assert.isNull(output, "OutputStream must not be null.", new Object[0]);
        if (content != null) {
            output.write(content);
        }
    }

    public static void write(char[] content, Writer writer) throws IOException {
        Assert.isNull(writer, "Writer must not be null.", new Object[0]);
        if (content != null) {
            writer.write(content);
        }
    }

    public static void write(CharSequence content, Writer writer) throws IOException {
        Assert.isNull(writer, "Writer must not be null.", new Object[0]);
        if (StringUtils.isNotBlank(content)) {
            writer.write(content.toString());
        }
    }

    public static void writeLine(CharSequence content, Writer writer) throws IOException {
        Assert.isNull(writer, "Writer must not be null.", new Object[0]);
        if (StringUtils.isNotBlank(content)) {
            writer.write(content.toString());
            writer.write(NEWLINE);
        }
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flushQuietly(OutputStream out) {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(OutputStream out) throws IOException {
        if (out != null) {
            out.flush();
        }
    }

    public static void flushQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void flush(Writer writer) throws IOException {
        if (writer != null) {
            writer.flush();
        }
    }

    public static void flushAndCloseQuietly(Writer writer) {
        IOUtils.flushQuietly(writer);
        IOUtils.closeQuietly(writer);
    }

    public static void flushAndCloseQuietly(OutputStream os) {
        IOUtils.flushQuietly(os);
        IOUtils.closeQuietly(os);
    }

    public static void flushAndClose(Writer writer) throws IOException {
        IOUtils.flushQuietly(writer);
        IOUtils.close(writer);
    }

    public static void flushAndClose(OutputStream os) throws IOException {
        IOUtils.flushQuietly(os);
        IOUtils.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyLines(Reader reader, Writer writer) throws IOException {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(writer, "Writer must not be null.", new Object[0]);
        try {
            String s;
            BufferedReader br = IOUtils.getBufferedReader(reader);
            while (null != (s = br.readLine())) {
                writer.write(s);
                writer.write(NEWLINE);
            }
        }
        finally {
            IOUtils.flushQuietly(writer);
        }
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IOUtils.copy(reader, writer, -1);
    }

    public static long copy(Reader reader, Writer writer, int maxSize) throws IOException {
        return IOUtils.copy(reader, writer, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(Reader reader, Writer writer, int bufferSize, int maxSize) throws IOException {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(writer, "Writer must not be null.", new Object[0]);
        boolean capped = maxSize > 0;
        int remaining = maxSize;
        char[] buffer = IOUtils.getCharBuffer(bufferSize);
        long length = 0L;
        try {
            int read;
            while (-1 != (read = reader.read(buffer))) {
                if (capped) {
                    if (read > remaining) {
                        writer.write(buffer, 0, remaining);
                        break;
                    }
                    remaining -= read;
                }
                writer.write(buffer, 0, read);
                length += (long)read;
            }
        }
        finally {
            IOUtils.flushQuietly(writer);
        }
        return length;
    }

    private static byte[] getByteBuffer(int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = 4096;
        }
        return new byte[bufferSize];
    }

    private static char[] getCharBuffer(int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = 4096;
        }
        return new char[bufferSize];
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, 4096, -1);
    }

    public static long copy(InputStream input, OutputStream output, int maxSize) throws IOException {
        return IOUtils.copy(input, output, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream input, OutputStream output, int bufferSize, int maxSize) throws IOException {
        Assert.isNull(input, "Input stream is null.", new Object[0]);
        Assert.isNull(output, "Output stream is null.", new Object[0]);
        boolean capped = maxSize > 0;
        int remaining = maxSize;
        byte[] buffer = IOUtils.getByteBuffer(bufferSize);
        long length = 0L;
        try {
            int read;
            while (-1 != (read = input.read(buffer))) {
                if (capped) {
                    if (read > remaining) {
                        output.write(buffer, 0, remaining);
                        break;
                    }
                    remaining -= read;
                }
                output.write(buffer, 0, read);
                length += (long)read;
            }
        }
        finally {
            IOUtils.flushQuietly(output);
        }
        return length;
    }

    public static void copy(InputStream input, Writer writer, String charset) throws IOException {
        IOUtils.copy(input, writer, CharsetUtils.toCharset(charset));
    }

    public static void copy(InputStream input, Writer writer, Charset charset) throws IOException {
        IOUtils.copy(input, writer, charset, -1);
    }

    public static void copy(InputStream input, Writer writer, Charset charset, int maxSize) throws IOException {
        IOUtils.copy(input, writer, charset, 4096, maxSize);
    }

    public static void copy(InputStream input, Writer writer, Charset charset, int bufferSize, int maxSize) throws IOException {
        Assert.isNull(input, "Input stream is null.", new Object[0]);
        InputStreamReader reader = new InputStreamReader(input, CharsetUtils.toCharset(charset));
        IOUtils.copy((Reader)reader, writer, bufferSize, maxSize);
    }

    public static void copy(byte[] input, Writer writer, String charset) throws IOException {
        IOUtils.copy(input, writer, CharsetUtils.toCharset(charset));
    }

    public static void copy(byte[] input, Writer writer, Charset charset) throws IOException {
        IOUtils.copy(input, writer, charset, -1);
    }

    public static void copy(byte[] input, Writer writer, Charset charset, int maxSize) throws IOException {
        IOUtils.copy(input, writer, charset, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(byte[] input, Writer writer, Charset charset, int bufferSize, int maxSize) throws IOException {
        Assert.isNull(input, "Input must not be null.", new Object[0]);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            IOUtils.copy(in, writer, charset, bufferSize, maxSize);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(char[] input, OutputStream output, Charset charset) throws IOException {
        Assert.isNull(input, "Input must not be null.", new Object[0]);
        CharArrayReader reader = null;
        try {
            reader = new CharArrayReader(input);
            IOUtils.copy((Reader)reader, output, charset);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
    }

    public static void copy(char[] input, OutputStream output, String charset) throws IOException {
        IOUtils.copy(input, output, CharsetUtils.toCharset(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(CharSequence input, OutputStream output, Charset charset) throws IOException {
        Assert.isNull(input, "Input must not be null.", new Object[0]);
        StringReader reader = null;
        try {
            reader = new StringReader(input.toString());
            IOUtils.copy((Reader)reader, output, charset);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
    }

    public static void copy(CharSequence input, OutputStream output, String charset) throws IOException {
        IOUtils.copy(input, output, CharsetUtils.toCharset(charset));
    }

    public static void copy(Reader reader, OutputStream output, Charset charset) throws IOException {
        IOUtils.copy(reader, output, charset, -1);
    }

    public static void copy(Reader reader, OutputStream output, Charset charset, int maxSize) throws IOException {
        IOUtils.copy(reader, output, charset, 4096, maxSize);
    }

    public static void copy(Reader reader, OutputStream output, Charset charset, int bufferSize, int maxSize) throws IOException {
        Assert.isNull(output, "Output must not be null.", new Object[0]);
        OutputStreamWriter out = new OutputStreamWriter(output, CharsetUtils.toCharset(charset));
        IOUtils.copy(reader, (Writer)out, bufferSize, maxSize);
    }

    public static void copy(Reader reader, OutputStream output, String charset) throws IOException {
        IOUtils.copy(reader, output, CharsetUtils.toCharset(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] toCharArray(InputStream input, Charset charset, int bufferSize, int maxSize) throws IOException {
        char[] cArray;
        CharArrayWriter output = null;
        try {
            output = new CharArrayWriter(bufferSize);
            IOUtils.copy(input, (Writer)output, charset, bufferSize, maxSize);
            cArray = output.toCharArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close(output);
        return cArray;
    }

    public static char[] toCharArray(InputStream input, Charset charset, int maxSize) throws IOException {
        return IOUtils.toCharArray(input, charset, 4096, maxSize);
    }

    public static char[] toCharArray(InputStream input, Charset charset) throws IOException {
        return IOUtils.toCharArray(input, charset, -1);
    }

    public static char[] toCharArray(InputStream is, String charset) throws IOException {
        return IOUtils.toCharArray(is, CharsetUtils.toCharset(charset));
    }

    public static CharBuffer toCharBuffer(InputStream input, Charset charset, int bufferSize, int maxSize) throws IOException {
        char[] chars = IOUtils.toCharArray(input, charset, bufferSize, maxSize);
        return CharBuffer.wrap(chars);
    }

    public static CharBuffer toCharBuffer(InputStream input, Charset charset, int maxSize) throws IOException {
        return IOUtils.toCharBuffer(input, charset, 4096, maxSize);
    }

    public static CharBuffer toCharBuffer(InputStream input, Charset charset) throws IOException {
        return IOUtils.toCharBuffer(input, charset, -1);
    }

    public static CharBuffer toCharBuffer(InputStream input, String charset) throws IOException {
        return IOUtils.toCharBuffer(input, CharsetUtils.toCharset(charset));
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray(input, -1);
    }

    public static byte[] toByteArray(InputStream input, int maxSize) throws IOException {
        return IOUtils.toByteArray(input, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream input, int bufferSize, int maxSize) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream(bufferSize);
            IOUtils.copy(input, (OutputStream)output, bufferSize, maxSize);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
        return byArray;
    }

    public static ByteBuffer toByteBuffer(InputStream input) throws IOException {
        return IOUtils.toByteBuffer(input, -1);
    }

    public static ByteBuffer toByteBuffer(InputStream input, int maxSize) throws IOException {
        return IOUtils.toByteBuffer(input, 4096, maxSize);
    }

    public static ByteBuffer toByteBuffer(InputStream input, int bufferSize, int maxSize) throws IOException {
        byte[] bytes = IOUtils.toByteArray(input, bufferSize, maxSize);
        return ByteBuffer.wrap(bytes);
    }

    public static String toString(InputStream is, Charset charset, int maxSize) throws IOException {
        return IOUtils.toString(is, charset, 4096, maxSize);
    }

    public static String toString(InputStream is, Charset charset, int bufferSize, int maxSize) throws IOException {
        char[] array = IOUtils.toCharArray(is, charset, bufferSize, maxSize);
        return new String(array);
    }

    public static String toString(InputStream is, Charset charset) throws IOException {
        return IOUtils.toString(is, charset, -1);
    }

    public static String toString(InputStream is, String charset) throws IOException {
        return IOUtils.toString(is, CharsetUtils.toCharset(charset));
    }

    public static String toString(Reader reader) throws IOException {
        return IOUtils.toString(reader, -1);
    }

    public static String toString(Reader reader, int maxSize) throws IOException {
        return IOUtils.toString(reader, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Reader reader, int bufferSize, int maxSize) throws IOException {
        StringWriter output = null;
        try {
            output = new StringWriter();
            IOUtils.copy(reader, (Writer)output, bufferSize, maxSize);
            String string = output.toString();
            return string;
        }
        finally {
            IOUtils.close(output);
        }
    }

    public static char[] toCharArray(Reader reader) throws IOException {
        return IOUtils.toCharArray(reader, -1);
    }

    public static char[] toCharArray(Reader reader, int maxSize) throws IOException {
        return IOUtils.toCharArray(reader, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] toCharArray(Reader reader, int bufferSize, int maxSize) throws IOException {
        CharArrayWriter output = null;
        try {
            output = new CharArrayWriter();
            IOUtils.copy(reader, (Writer)output, bufferSize, maxSize);
            char[] cArray = output.toCharArray();
            return cArray;
        }
        finally {
            IOUtils.close(output);
        }
    }

    public static byte[] toByteArray(Reader reader, String charset) throws IOException {
        return IOUtils.toByteArray(reader, CharsetUtils.toCharset(charset));
    }

    public static byte[] toByteArray(Reader reader, Charset charset) throws IOException {
        return IOUtils.toByteArray(reader, charset, -1);
    }

    public static byte[] toByteArray(Reader reader, Charset charset, int maxSize) throws IOException {
        return IOUtils.toByteArray(reader, charset, 4096, maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Reader reader, Charset charset, int bufferSize, int maxSize) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream output = null;
        try {
            output = new ByteArrayOutputStream(bufferSize);
            IOUtils.copy(reader, output, charset, bufferSize, maxSize);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close(output);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyLines(Reader reader, StringBuffer str) throws IOException {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(str, "Output must not bs null.", new Object[0]);
        BufferedReader br = null;
        int line = 1;
        try {
            String nextLine;
            br = IOUtils.getBufferedReader(reader);
            while (null != (nextLine = br.readLine())) {
                str.append(nextLine);
                str.append(NEWLINE);
                ++line;
            }
        }
        finally {
            IOUtils.close(br);
        }
        return line;
    }

    public static int copyLines(InputStream in, Charset charset, StringBuffer str) throws IOException {
        return IOUtils.copyLines((Reader)new InputStreamReader(in, CharsetUtils.toCharset(charset)), str);
    }

    public static int copyLines(InputStream in, String charset, StringBuffer str) throws IOException {
        return IOUtils.copyLines(in, CharsetUtils.toCharset(charset), str);
    }

    public static int copyLines(InputStream in, Charset charset, StringBuilder str) throws IOException {
        return IOUtils.copyLines((Reader)new InputStreamReader(in, CharsetUtils.toCharset(charset)), str);
    }

    public static int copyLines(InputStream in, String charset, StringBuilder str) throws IOException {
        return IOUtils.copyLines(in, CharsetUtils.toCharset(charset), str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyLines(Reader reader, StringBuilder str) throws IOException {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(str, "Output must not bs null.", new Object[0]);
        BufferedReader br = null;
        int line = 1;
        try {
            String nextLine;
            br = IOUtils.getBufferedReader(reader);
            while (null != (nextLine = br.readLine())) {
                str.append(nextLine);
                str.append(NEWLINE);
                ++line;
            }
        }
        finally {
            IOUtils.close(br);
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyLines(Reader reader, List<String> results) throws IOException {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(results, "Output must not bs null.", new Object[0]);
        BufferedReader br = null;
        try {
            String nextLine;
            br = IOUtils.getBufferedReader(reader);
            while (null != (nextLine = br.readLine())) {
                results.add(nextLine);
            }
        }
        finally {
            IOUtils.close(br);
        }
    }

    public static void copyLines(InputStream in, Charset charset, List<String> results) throws IOException {
        Assert.isNull(in, "Input stream must not be null.", new Object[0]);
        IOUtils.copyLines((Reader)new InputStreamReader(in, CharsetUtils.toCharset(charset)), results);
    }

    public static void copyLines(InputStream in, String charset, List<String> results) throws IOException {
        IOUtils.copyLines(in, CharsetUtils.toCharset(charset), results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyLines(byte[] bytes, Charset charset, List<String> results) throws IOException {
        Assert.isNull(bytes, "Input must not be null.", new Object[0]);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(bytes);
            IOUtils.copyLines((InputStream)in, charset, results);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
    }

    public static void copyLines(byte[] bytes, String charset, List<String> results) throws IOException {
        IOUtils.copyLines(bytes, CharsetUtils.toCharset(charset), results);
    }

    public static void copyLines(char[] array, List<String> results) throws IOException {
        CharArrayReader reader = null;
        try {
            reader = new CharArrayReader(array);
            IOUtils.copyLines((Reader)reader, results);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
    }

    public static void writeLines(Map<String, String> results, Writer writer) throws IOException {
        IOUtils.writeLines(results, writer, "=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(Map<String, String> results, Writer writer, String separator) throws IOException {
        BufferedWriter bw = IOUtils.getBufferedWriter(writer);
        try {
            for (Map.Entry<String, String> en : results.entrySet()) {
                bw.write(en.getKey() + separator + en.getValue());
                bw.newLine();
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }

    public static void writeLines(Map<String, String> results, OutputStream os, String charset) throws IOException {
        IOUtils.writeLines(results, os, CharsetUtils.toCharset(charset));
    }

    public static void writeLines(Map<String, String> results, OutputStream os, Charset charset) throws IOException {
        IOUtils.writeLines(results, os, charset, "=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(Map<String, String> results, OutputStream os, Charset charset, String separator) throws IOException {
        BufferedWriter bw = IOUtils.getBufferedWriter(os, charset);
        try {
            for (Map.Entry<String, String> en : results.entrySet()) {
                bw.write(en.getKey() + separator + en.getValue());
                bw.newLine();
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }

    public static void writeLines(Enumeration<String> results, Writer writer) throws IOException {
        BufferedWriter bw = IOUtils.getBufferedWriter(writer);
        try {
            while (results.hasMoreElements()) {
                bw.write(results.nextElement());
                bw.newLine();
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }

    public static void writeLines(Enumeration<String> results, OutputStream os, String charset) throws IOException {
        IOUtils.writeLines(results, os, CharsetUtils.toCharset(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(Enumeration<String> results, OutputStream os, Charset charset) throws IOException {
        BufferedWriter bw = IOUtils.getBufferedWriter(os, charset);
        try {
            while (results.hasMoreElements()) {
                bw.write(results.nextElement());
                bw.newLine();
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }

    public static void writeLines(Iterator<String> results, Writer writer) throws IOException {
        BufferedWriter bw = IOUtils.getBufferedWriter(writer);
        try {
            while (results.hasNext()) {
                bw.write(results.next());
                bw.newLine();
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }

    public static void writeLines(Iterator<String> results, OutputStream os, String charset) throws IOException {
        IOUtils.writeLines(results, os, CharsetUtils.toCharset(charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(Iterator<String> results, OutputStream os, Charset charset) throws IOException {
        BufferedWriter bw = IOUtils.getBufferedWriter(os, charset);
        try {
            while (results.hasNext()) {
                bw.write(results.next());
                bw.newLine();
            }
        }
        finally {
            IOUtils.flushQuietly(bw);
        }
    }

    public static void writeLines(Collection<String> results, Writer writer) throws IOException {
        IOUtils.writeLines(results.iterator(), writer);
    }

    public static void writeLines(Collection<String> results, OutputStream os, String charset) throws IOException {
        IOUtils.writeLines(results, os, CharsetUtils.toCharset(charset));
    }

    public static void writeLines(Collection<String> results, OutputStream os, Charset charset) throws IOException {
        IOUtils.writeLines(results.iterator(), os, charset);
    }

    public static void checkRange(int start, int limit) throws IOException {
        boolean result;
        boolean bl = result = start > 0 && limit < 0 || start > 0 && limit > 0 && start < start + limit;
        if (!result) {
            throw new IOException("Invalid range input: " + start + ", " + limit);
        }
    }

    static boolean isValidLine(int start, int limit, int lineNumber) {
        return limit < 0 || lineNumber < start + limit - 1;
    }

    public static void rangeCopyLines(LineNumberReader reader, int start, int limit, List<String> results) throws IOException {
        String nextLine;
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(results, "Output must not be null.", new Object[0]);
        IOUtils.checkRange(start, limit);
        reader.mark(start);
        while (null != (nextLine = reader.readLine())) {
            int n = reader.getLineNumber();
            if (n < start) continue;
            results.add(nextLine);
            if (IOUtils.isValidLine(start, limit, n)) continue;
            break;
        }
    }

    public static void rangeCopyLines(LineNumberReader reader, int start, int limit, StringBuffer str) throws IOException {
        String nextLine;
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(str, "Output must not be null.", new Object[0]);
        IOUtils.checkRange(start, limit);
        reader.mark(start);
        while (null != (nextLine = reader.readLine())) {
            int n = reader.getLineNumber();
            if (n < start) continue;
            str.append(nextLine);
            if (!IOUtils.isValidLine(start, limit, n)) break;
            str.append(NEWLINE);
        }
    }

    public static void rangeCopyLines(LineNumberReader reader, int start, int limit, StringBuilder str) throws IOException {
        String nextLine;
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        Assert.isNull(str, "Output must not be null.", new Object[0]);
        IOUtils.checkRange(start, limit);
        reader.mark(start);
        while (null != (nextLine = reader.readLine())) {
            int n = reader.getLineNumber();
            if (n < start) continue;
            str.append(nextLine);
            if (!IOUtils.isValidLine(start, limit, n)) break;
            str.append(NEWLINE);
        }
    }

    public static BufferedInputStream getBufferedInputStream(InputStream in) {
        return IOUtils.getBufferedInputStream(in, 4096);
    }

    public static BufferedOutputStream getBufferedOutputStream(OutputStream out) {
        return IOUtils.getBufferedOutputStream(out, 4096);
    }

    public static BufferedInputStream getBufferedInputStream(InputStream in, int size) {
        Assert.isNull(in, "Input stream must not be null.", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in, size);
    }

    public static BufferedOutputStream getBufferedOutputStream(OutputStream out, int size) {
        Assert.isNull(out, "Output stream must not be null.", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out, size);
    }

    public static BufferedReader getBufferedReader(Reader reader) {
        return IOUtils.getBufferedReader(reader, 4096);
    }

    public static LineNumberReader getLineNumberReader(Reader reader) {
        return IOUtils.getLineNumberReader(reader, 4096);
    }

    public static BufferedWriter getBufferedWriter(Writer writer) {
        return IOUtils.getBufferedWriter(writer, 4096);
    }

    public static BufferedReader getBufferedReader(Reader reader, int size) {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size);
    }

    public static LineNumberReader getLineNumberReader(Reader reader, int size) {
        Assert.isNull(reader, "Reader must not be null.", new Object[0]);
        return reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader, size);
    }

    public static BufferedWriter getBufferedWriter(Writer writer, int size) {
        Assert.isNull(writer, "Writer must not be null.", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, size);
    }

    public static BufferedReader getBufferedReader(InputStream in, Charset charset) {
        return IOUtils.getBufferedReader(in, charset, 4096);
    }

    public static LineNumberReader getLineNumberReader(InputStream in, Charset charset, int size) {
        Assert.isNull(in, "Input stream must not be null.", new Object[0]);
        return IOUtils.getLineNumberReader(new InputStreamReader(in, CharsetUtils.toCharset(charset)), size);
    }

    public static LineNumberReader getLineNumberReader(InputStream in, Charset charset) {
        return IOUtils.getLineNumberReader(in, charset, 4096);
    }

    public static LineNumberReader getLineNumberReader(InputStream in, String charset, int size) {
        return IOUtils.getLineNumberReader(in, CharsetUtils.toCharset(charset), size);
    }

    public static LineNumberReader getLineNumberReader(InputStream in, String charset) {
        return IOUtils.getLineNumberReader(in, charset, 4096);
    }

    public static BufferedReader getBufferedReader(InputStream in, String charset) {
        return IOUtils.getBufferedReader(in, CharsetUtils.toCharset(charset));
    }

    public static BufferedReader getBufferedReader(InputStream in, Charset charset, int size) {
        Assert.isNull(in, "Input stream must not be null.", new Object[0]);
        return IOUtils.getBufferedReader(new InputStreamReader(in, CharsetUtils.toCharset(charset)), size);
    }

    public static BufferedReader getBufferedReader(InputStream in, String charset, int size) {
        return IOUtils.getBufferedReader(in, CharsetUtils.toCharset(charset), size);
    }

    public static BufferedWriter getBufferedWriter(OutputStream os, Charset charset) {
        return IOUtils.getBufferedWriter(os, charset, 4096);
    }

    public static BufferedWriter getBufferedWriter(OutputStream os, String charset) {
        return IOUtils.getBufferedWriter(os, CharsetUtils.toCharset(charset));
    }

    public static BufferedWriter getBufferedWriter(OutputStream os, Charset charset, int size) {
        return IOUtils.getBufferedWriter(new OutputStreamWriter(os, CharsetUtils.toCharset(charset)), size);
    }

    public static BufferedWriter getBufferedWriter(OutputStream os, String charset, int size) {
        return IOUtils.getBufferedWriter(os, CharsetUtils.toCharset(charset), size);
    }

    public static ObjectInputStream getObjectInputStream(InputStream in) throws IOException {
        return in instanceof ObjectInputStream ? (ObjectInputStream)in : new ObjectInputStream(in);
    }

    public static ObjectOutputStream getObjectOutputStream(OutputStream out) throws IOException {
        return out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
    }

    public static DataInputStream getDataInputStream(InputStream in) {
        return in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
    }

    public static DataOutputStream getDataOutputStream(OutputStream out) {
        return out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
    }

    public static GZIPInputStream getGZIPInputStream(InputStream in) throws IOException {
        return IOUtils.getGZIPInputStream(in, 1024);
    }

    public static GZIPInputStream getGZIPInputStream(InputStream in, int size) throws IOException {
        return in instanceof GZIPInputStream ? (GZIPInputStream)in : new GZIPInputStream(in, size);
    }

    public static GZIPOutputStream getGZIPOutputStream(OutputStream out) throws IOException {
        return IOUtils.getGZIPOutputStream(out, 1024);
    }

    public static GZIPOutputStream getGZIPOutputStream(OutputStream out, int size) throws IOException {
        return out instanceof GZIPOutputStream ? (GZIPOutputStream)out : new GZIPOutputStream(out, size);
    }

    public static ByteBuffer emptyByteBuffer() {
        return ByteBuffer.allocate(0);
    }
}

