/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.MatchMode;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.io.IniConfig;
import com.github.paganini2008.devtools.io.RealtimeRefreshingIniConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class RefreshingIniConfig
implements IniConfig,
Serializable {
    private static final long serialVersionUID = -5059524272830465517L;
    private IniConfig delegate;

    protected abstract IniConfig getConfig() throws Exception;

    @Override
    public Map<String, String> set(String section, Map<String, String> kwargs) {
        return this.delegate.set(section, kwargs);
    }

    @Override
    public String set(String section, String name, String value) {
        return this.delegate.set(section, name, value);
    }

    @Override
    public String[] sections() {
        return this.delegate.sections();
    }

    @Override
    public Map<String, String> get(String section) {
        return this.delegate.get(section);
    }

    @Override
    public Map<String, String> get(String section, String substr, MatchMode mode) {
        return this.delegate.get(section, substr, mode);
    }

    @Override
    public String getString(String section, String name) {
        return this.getString(section, name, null);
    }

    @Override
    public String getString(String section, String name, String defaultValue) {
        return this.delegate.getString(section, name, defaultValue);
    }

    @Override
    public Byte getByte(String section, String name) {
        return this.getByte(section, name, null);
    }

    @Override
    public Byte getByte(String section, String name, Byte defaultValue) {
        return this.delegate.getByte(section, name, defaultValue);
    }

    @Override
    public Short getShort(String section, String name) {
        return this.getShort(section, name, null);
    }

    @Override
    public Short getShort(String section, String name, Short defaultValue) {
        return this.delegate.getShort(section, name, defaultValue);
    }

    @Override
    public Integer getInteger(String section, String name) {
        return this.getInteger(section, name, null);
    }

    @Override
    public Integer getInteger(String section, String name, Integer defaultValue) {
        return this.delegate.getInteger(section, name, defaultValue);
    }

    @Override
    public Long getLong(String section, String name) {
        return this.getLong(section, name, null);
    }

    @Override
    public Long getLong(String section, String name, Long defaultValue) {
        return this.delegate.getLong(section, name, defaultValue);
    }

    @Override
    public Float getFloat(String section, String name) {
        return this.getFloat(section, name, null);
    }

    @Override
    public Float getFloat(String section, String name, Float defaultValue) {
        return this.delegate.getFloat(section, name, defaultValue);
    }

    @Override
    public Double getDouble(String section, String name) {
        return this.getDouble(section, name, null);
    }

    @Override
    public Double getDouble(String section, String name, Double defaultValue) {
        return this.delegate.getDouble(section, name, defaultValue);
    }

    @Override
    public Boolean getBoolean(String section, String name) {
        return this.getBoolean(section, name, null);
    }

    @Override
    public Boolean getBoolean(String section, String name, Boolean defaultValue) {
        return this.delegate.getBoolean(section, name, defaultValue);
    }

    public synchronized boolean refresh() throws Exception {
        boolean hasChanged = false;
        IniConfig latestVersion = this.getConfig();
        if (this.delegate != null) {
            Map<String, Map<String, String>> currentVersion = this.delegate.toMap();
            for (String section : latestVersion) {
                Map<String, String> latest = latestVersion.get(section);
                if (currentVersion.containsKey(section)) {
                    Map<String, String> current = currentVersion.get(section);
                    if (MapUtils.deepEquals(latest, current)) continue;
                    this.onChange(section, latest, current);
                    hasChanged = true;
                    continue;
                }
                this.onChange(section, latest, null);
                hasChanged = true;
            }
        }
        this.delegate = latestVersion;
        return hasChanged;
    }

    protected void onChange(String section, Map<String, String> latest, Map<String, String> current) {
    }

    @Override
    public Iterator<String> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Map<String, Map<String, String>> toMap() {
        return this.delegate.toMap();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void store(OutputStream os, String charset) throws IOException {
        this.delegate.store(os, charset);
    }

    public RealtimeRefreshingIniConfig refresh(int interval) {
        return new RealtimeRefreshingIniConfig(this, interval);
    }
}

