/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.io.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class SerializationUtils {
    public static <T> T copy(T serializable) {
        byte[] bytes = SerializationUtils.serialize(serializable, false);
        return (T)SerializationUtils.deserialize(bytes, false);
    }

    public static <T> List<T> copyMany(T serializable, int count) {
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            list.add(SerializationUtils.copy(serializable));
        }
        return list;
    }

    public static void writeObject(Object serializable, File file, boolean compress) {
        Assert.isNull(file, "Undefined output file.", new Object[0]);
        FileOutputStream fos = null;
        try {
            fos = FileUtils.openOutputStream(file);
            SerializationUtils.writeObject(serializable, fos, compress);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            IOUtils.closeQuietly(fos);
        }
    }

    public static byte[] serialize(Object serializable, boolean compress) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        SerializationUtils.writeObject(serializable, output, compress);
        return output.toByteArray();
    }

    public static Object deserialize(byte[] data, boolean compress) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        return SerializationUtils.readObject(bis, compress);
    }

    public static void writeObject(Object object, OutputStream os, boolean compress) {
        if (!(object instanceof Serializable)) {
            throw new SerializationException("Not serialiazble object");
        }
        Assert.isNull(os, "OutputStream must not be null.", new Object[0]);
        ObjectOutputStream oos = null;
        try {
            oos = IOUtils.getObjectOutputStream(compress ? IOUtils.getGZIPOutputStream(os) : os);
            oos.writeObject(object);
        }
        catch (IOException e) {
            try {
                throw new SerializationException(e);
            }
            catch (Throwable throwable) {
                IOUtils.flushAndCloseQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.flushAndCloseQuietly(oos);
    }

    public static Object readObject(InputStream is) {
        return SerializationUtils.readObject(is, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObject(InputStream is, boolean compress) {
        Object object;
        Assert.isNull(is, "InputStream must not be null.", new Object[0]);
        ObjectInputStream ois = null;
        try {
            ois = IOUtils.getObjectInputStream(compress ? IOUtils.getGZIPInputStream(is) : is);
            object = ois.readObject();
        }
        catch (IOException e) {
            try {
                throw new SerializationException(e);
                catch (ClassNotFoundException e2) {
                    throw new SerializationException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ois);
        return object;
    }

    public static Object readObject(File file, boolean compress) {
        Assert.isNull(file, "Undefined input file.", new Object[0]);
        FileInputStream fis = null;
        try {
            fis = FileUtils.openInputStream(file);
            Object object = SerializationUtils.readObject(fis, compress);
            return object;
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
    }
}

