/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.io.monitor;

import com.github.paganini2008.devtools.collection.ListUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.io.FileUtils;
import com.github.paganini2008.devtools.io.monitor.FileChangeListener;
import com.github.paganini2008.devtools.io.monitor.FileEntry;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileWatcher {
    private FileEntry rootEntry;
    private final File directory;
    private final FileFilter fileFilter;
    private final int depth;
    private final List<FileChangeListener> listeners = new CopyOnWriteArrayList<FileChangeListener>();

    public FileWatcher(File directory, int depth, FileFilter fileFilter) {
        this.directory = directory;
        this.depth = depth;
        this.fileFilter = fileFilter;
    }

    public void addListeners(FileChangeListener ... l) {
        if (l != null) {
            for (FileChangeListener listener : l) {
                this.listeners.add(listener);
            }
        }
    }

    public void removeListeners(FileChangeListener ... l) {
        if (l != null) {
            for (FileChangeListener listener : l) {
                this.listeners.remove(listener);
            }
        }
    }

    public void start() {
        this.rootEntry = new FileEntry(this.directory);
        this.rootEntry.refresh();
        List<File> rootChildFiles = this.listFiles(this.rootEntry.getFile());
        if (ListUtils.isNotEmpty(rootChildFiles)) {
            LinkedHashMap<String, FileEntry> rootChildEntries = new LinkedHashMap<String, FileEntry>();
            for (File rootChildFile : rootChildFiles) {
                rootChildEntries.put(rootChildFile.getAbsolutePath(), this.createFileEntry(this.rootEntry, rootChildFile));
            }
            this.rootEntry.setChildEntries(rootChildEntries);
        }
    }

    private FileEntry createFileEntry(FileEntry parentEntry, File childFile) {
        List<File> childFiles;
        FileEntry childEntry = parentEntry.newChildEntry(childFile);
        if ((this.depth < 0 || childEntry.getDepth() <= this.depth) && ListUtils.isNotEmpty(childFiles = this.listFiles(childEntry.getFile()))) {
            LinkedHashMap<String, FileEntry> childEntries = new LinkedHashMap<String, FileEntry>();
            for (File file : childFiles) {
                childEntries.put(file.getAbsolutePath(), this.createFileEntry(childEntry, file));
            }
            childEntry.setChildEntries(childEntries);
        } else {
            childEntry.setChildEntries(Collections.EMPTY_MAP);
        }
        return childEntry;
    }

    private FileEntry createFileEntry(FileEntry parentEntry, File childFile, Map<String, FileEntry> lastChildEntries) {
        List<File> listChildFiles;
        FileEntry childEntry = parentEntry.newChildEntry(childFile);
        if ((this.depth < 0 || childEntry.getDepth() <= this.depth) && ListUtils.isNotEmpty(listChildFiles = this.listFiles(childEntry.getFile()))) {
            LinkedHashMap<String, FileEntry> childEntries = new LinkedHashMap<String, FileEntry>();
            Map<String, FileEntry> comparedChildEntries = this.getChildFileChildEntries(childFile, lastChildEntries);
            for (File file : listChildFiles) {
                childEntries.put(file.getAbsolutePath(), this.createFileEntry(childEntry, file, comparedChildEntries));
            }
            this.compareAndCall(childEntries, comparedChildEntries);
            childEntry.setChildEntries(childEntries);
        } else {
            childEntry.setChildEntries(Collections.EMPTY_MAP);
        }
        return childEntry;
    }

    private void deleteChildEntries(Map<String, FileEntry> childEntries) {
        for (Map.Entry<String, FileEntry> en : childEntries.entrySet()) {
            FileEntry fileEntry = en.getValue();
            for (FileChangeListener listener : this.listeners) {
                if (fileEntry.isDirectory()) {
                    listener.onDirectoryDelete(fileEntry);
                    continue;
                }
                listener.onFileDelete(fileEntry);
            }
            this.deleteChildEntries(fileEntry.getChildEntries());
        }
    }

    private Map<String, FileEntry> getChildFileChildEntries(File childFile, Map<String, FileEntry> lastChildEntries) {
        if (lastChildEntries != null) {
            FileEntry fileEntry = lastChildEntries.get(childFile.getAbsolutePath());
            return fileEntry != null ? fileEntry.getChildEntries() : Collections.EMPTY_MAP;
        }
        return Collections.EMPTY_MAP;
    }

    private void compareAndCall(Map<String, FileEntry> childEntries, Map<String, FileEntry> lastChildEntries) {
        FileEntry fileEntry;
        Map<String, FileEntry> effectedEntries = MapUtils.minus(childEntries, lastChildEntries);
        for (Map.Entry<String, FileEntry> en : effectedEntries.entrySet()) {
            fileEntry = en.getValue();
            for (FileChangeListener listener : this.listeners) {
                if (fileEntry.isDirectory()) {
                    listener.onDirectoryCreate(fileEntry);
                    continue;
                }
                listener.onFileCreate(fileEntry);
            }
        }
        effectedEntries = MapUtils.intersect(childEntries, lastChildEntries);
        for (Map.Entry<String, FileEntry> en : effectedEntries.entrySet()) {
            FileEntry lastFileEntry;
            fileEntry = en.getValue();
            if (!fileEntry.compareTo(lastFileEntry = lastChildEntries.get(en.getKey()))) continue;
            for (FileChangeListener listener : this.listeners) {
                if (fileEntry.isDirectory()) {
                    listener.onDirectoryUpdate(lastFileEntry, fileEntry);
                    continue;
                }
                listener.onFileUpdate(lastFileEntry, fileEntry);
            }
        }
        effectedEntries = MapUtils.minus(lastChildEntries, childEntries);
        for (Map.Entry<String, FileEntry> en : effectedEntries.entrySet()) {
            fileEntry = en.getValue();
            for (FileChangeListener listener : this.listeners) {
                if (fileEntry.isDirectory()) {
                    listener.onDirectoryDelete(fileEntry);
                    continue;
                }
                listener.onFileDelete(fileEntry);
            }
            this.deleteChildEntries(fileEntry.getChildEntries());
        }
    }

    public void refresh() {
        FileEntry lastRootEntry = this.rootEntry;
        this.rootEntry = new FileEntry(this.directory);
        this.rootEntry.refresh();
        if (!lastRootEntry.isExists() && this.rootEntry.isExists()) {
            for (FileChangeListener listener : this.listeners) {
                if (this.rootEntry.isDirectory()) {
                    listener.onDirectoryCreate(this.rootEntry);
                    continue;
                }
                listener.onFileCreate(this.rootEntry);
            }
        } else if (lastRootEntry.isExists() && !this.rootEntry.isExists()) {
            for (FileChangeListener listener : this.listeners) {
                if (lastRootEntry.isDirectory()) {
                    listener.onDirectoryDelete(lastRootEntry);
                    continue;
                }
                listener.onFileDelete(lastRootEntry);
            }
            this.deleteChildEntries(lastRootEntry.getChildEntries());
        } else if (lastRootEntry.compareTo(this.rootEntry)) {
            for (FileChangeListener listener : this.listeners) {
                if (this.rootEntry.isDirectory()) {
                    listener.onDirectoryUpdate(lastRootEntry, this.rootEntry);
                    continue;
                }
                listener.onFileUpdate(lastRootEntry, this.rootEntry);
            }
        }
        List<File> childFiles = this.listFiles(this.rootEntry.getFile());
        if (ListUtils.isNotEmpty(childFiles)) {
            LinkedHashMap<String, FileEntry> childEntries = new LinkedHashMap<String, FileEntry>();
            for (File childFile : childFiles) {
                childEntries.put(childFile.getAbsolutePath(), this.createFileEntry(this.rootEntry, childFile, lastRootEntry.getChildEntries()));
            }
            this.compareAndCall(childEntries, lastRootEntry.getChildEntries());
            this.rootEntry.setChildEntries(childEntries);
        } else {
            this.rootEntry.setChildEntries(Collections.EMPTY_MAP);
        }
    }

    public void checkAndNotify() {
        for (FileChangeListener listener : this.listeners) {
            listener.onStart(this);
        }
        this.refresh();
        for (FileChangeListener listener : this.listeners) {
            listener.onEnd(this);
        }
    }

    protected List<File> listFiles(File directory) {
        return FileUtils.listFiles(directory, this.fileFilter);
    }

    public FileEntry getRootEntry() {
        return this.rootEntry;
    }

    public File getDirectory() {
        return this.directory;
    }
}

