/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.jdbc;

import com.github.paganini2008.devtools.jdbc.AbstractDataSource;
import com.github.paganini2008.devtools.jdbc.JdbcUtils;
import com.github.paganini2008.devtools.jdbc.TransactionIsolationLevel;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.Semaphore;

public class UnpooledDataSource
extends AbstractDataSource {
    private String driverClassName;
    private String url;
    private String user;
    private String password;
    private Boolean autoCommit;
    private TransactionIsolationLevel transactionIsolationLevel;
    private Integer maxSize = 16;
    private Semaphore semaphore;

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public Boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public void setDriverClassName(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknow driverClassName: " + driverClassName, e);
        }
        this.driverClassName = driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    public TransactionIsolationLevel getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(TransactionIsolationLevel transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        DriverManager.setLogWriter(logWriter);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException(this.getClass().getName() + " is not a wrapper.");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.semaphore == null) {
            UnpooledDataSource unpooledDataSource = this;
            synchronized (unpooledDataSource) {
                if (this.semaphore == null) {
                    this.semaphore = new Semaphore(this.maxSize);
                }
            }
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Connection connection = JdbcUtils.getConnection(this.url, this.user, this.password);
        this.configureConnection(connection);
        return new ConnectionProxy(connection, this.semaphore).getProxyConnection();
    }

    protected void configureConnection(Connection connection) throws SQLException {
        if (this.autoCommit != null) {
            connection.setAutoCommit(this.autoCommit);
        }
        if (this.transactionIsolationLevel != null) {
            connection.setTransactionIsolation(this.transactionIsolationLevel.getLevel());
        }
    }

    static class ConnectionProxy
    implements InvocationHandler {
        private static final String CLOSE = "close";
        private static final Class<?>[] IFACES = new Class[]{Connection.class};
        private final Connection realConnection;
        private final Connection proxyConnection;
        private final Semaphore semaphore;

        ConnectionProxy(Connection realConnection, Semaphore semaphore) {
            this.realConnection = realConnection;
            this.semaphore = semaphore;
            this.proxyConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), IFACES, (InvocationHandler)this);
        }

        public Connection getRealConnection() {
            return this.realConnection;
        }

        public Connection getProxyConnection() {
            return this.proxyConnection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                return this.realConnection == args[0];
            }
            if (methodName.equals("hashCode")) {
                return System.identityHashCode(this.realConnection);
            }
            if (methodName.equals("toString")) {
                return this.realConnection.toString();
            }
            if (CLOSE.hashCode() == methodName.hashCode() && CLOSE.equals(methodName)) {
                JdbcUtils.closeQuietly(this.realConnection);
                this.semaphore.release();
                return null;
            }
            return method.invoke((Object)this.realConnection, args);
        }
    }
}

