/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import java.util.concurrent.atomic.AtomicInteger;

public class AtomicUnsignedInteger
extends Number {
    private static final long serialVersionUID = 6144822865358352926L;
    private final AtomicInteger i;
    private final int initialValue;
    private final int maxValue;

    public AtomicUnsignedInteger() {
        this(0);
    }

    public AtomicUnsignedInteger(int initialValue) {
        this(initialValue, Integer.MAX_VALUE);
    }

    public AtomicUnsignedInteger(int initialValue, int maxValue) {
        if (initialValue < 0) {
            throw new IllegalArgumentException("Initial value must >= 0.");
        }
        if (initialValue >= maxValue) {
            throw new IllegalArgumentException("Maximum value must > initial value.");
        }
        this.i = new AtomicInteger(initialValue);
        this.initialValue = initialValue;
        this.maxValue = maxValue;
    }

    public int getAndIncrement() {
        int next;
        int current;
        while (!this.i.compareAndSet(current, next = (current = this.i.get()) >= this.maxValue ? this.initialValue : current + 1)) {
        }
        return current;
    }

    public int getAndDecrement() {
        int next;
        int current;
        while (!this.i.compareAndSet(current, next = (current = this.i.get()) <= this.initialValue ? this.maxValue : current - 1)) {
        }
        return current;
    }

    public int incrementAndGet() {
        int next;
        int current;
        while (!this.i.compareAndSet(current, next = (current = this.i.get()) >= this.maxValue ? this.initialValue : current + 1)) {
        }
        return next;
    }

    public int decrementAndGet() {
        int next;
        int current;
        while (!this.i.compareAndSet(current, next = (current = this.i.get()) <= this.initialValue ? this.maxValue : current - 1)) {
        }
        return next;
    }

    public int get() {
        return this.i.get();
    }

    public void set(int newValue) {
        if (newValue < this.initialValue || newValue > this.maxValue) {
            throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
        }
        this.i.set(newValue);
    }

    public int getAndSet(int newValue) {
        if (newValue >= this.initialValue && newValue <= this.maxValue) {
            return this.i.getAndSet(newValue);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    public int getAndAdd(int delta) {
        int next;
        int current;
        while (!this.i.compareAndSet(current, next = (current = this.i.get()) > this.maxValue - delta ? this.initialValue : current + delta)) {
        }
        return current;
    }

    public int addAndGet(int delta) {
        int next;
        int current;
        while (!this.i.compareAndSet(current, next = (current = this.i.get()) > this.maxValue - delta ? this.initialValue : current + delta)) {
        }
        return next;
    }

    public boolean compareAndSet(int expect, int update) {
        if (update >= this.initialValue && update <= this.maxValue) {
            return this.i.compareAndSet(expect, update);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    public boolean weakCompareAndSet(int expect, int update) {
        if (update >= this.initialValue && update <= this.maxValue) {
            return this.i.weakCompareAndSet(expect, update);
        }
        throw new IllegalArgumentException("New value must >= " + this.initialValue + " and <= " + this.maxValue + ".");
    }

    @Override
    public byte byteValue() {
        return this.i.byteValue();
    }

    @Override
    public short shortValue() {
        return this.i.shortValue();
    }

    @Override
    public int intValue() {
        return this.i.intValue();
    }

    @Override
    public long longValue() {
        return this.i.longValue();
    }

    @Override
    public float floatValue() {
        return this.i.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.i.doubleValue();
    }

    public String toString() {
        return this.i.toString();
    }

    public int hashCode() {
        int result = 37;
        return result += Integer.hashCode(this.get());
    }

    public boolean equals(Object other) {
        if (other instanceof AtomicUnsignedInteger) {
            AtomicUnsignedInteger integer = (AtomicUnsignedInteger)other;
            return integer.get() == this.get();
        }
        return false;
    }
}

