/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.ExecutorUtils;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;

public final class Producer<X, R> {
    private final Executor threadPool;
    private final Caller caller;

    public Producer(Executor executor, Consumer<X, R> consumer) {
        this(executor, new LinkedBlockingQueue(), consumer);
    }

    public Producer(Executor executor, Queue<X> workQueue, Consumer<X, R> consumer) {
        this.threadPool = executor;
        this.caller = new Caller(workQueue, consumer);
    }

    public void produce(X action) {
        this.caller.workQueue.offer(action);
        this.threadPool.execute(this.caller);
    }

    public void join() {
        if (this.threadPool instanceof ThreadPool) {
            ((ThreadPool)this.threadPool).shutdown();
        }
        ExecutorUtils.gracefulShutdown(this.threadPool, 60000L);
    }

    public static <X, R> long executeBatch(Iterator<X> batch, int nThreads, Consumer<X, R> consumer) {
        long start = System.currentTimeMillis();
        Producer<X, R> producer = new Producer<X, R>(ThreadUtils.commonPool(nThreads), consumer);
        while (batch.hasNext()) {
            producer.produce(batch.next());
        }
        producer.join();
        return System.currentTimeMillis() - start;
    }

    public static void main(String[] args) throws Exception {
        long time = Producer.executeBatch(Sequence.forEach(1, 100).iterator(), 10, new Consumer<Integer, Long>(){

            @Override
            public Long consume(Integer action) throws Exception {
                return (long)action;
            }

            @Override
            public Long onSuccess(Long result, Integer action) {
                System.out.println("Result: " + result);
                return null;
            }
        });
        System.out.println("Time: " + time);
    }

    public static interface Consumer<X, R> {
        public R consume(X var1) throws Exception;

        default public boolean shouldCallback(R result) {
            return result != null;
        }

        default public void onFailure(X action, Exception cause) {
            cause.printStackTrace();
        }

        default public R onSuccess(R result, X action) {
            return null;
        }
    }

    class Caller
    implements Runnable {
        final Map<X, R> resultArea = new ConcurrentHashMap();
        final Queue<X> workQueue;
        final Consumer<X, R> consumer;

        Caller(Queue<X> workQueue, Consumer<X, R> consumer) {
            this.workQueue = workQueue;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object result = null;
            Exception cause = null;
            Object action = this.workQueue.poll();
            if (this.resultArea.containsKey(action)) {
                try {
                    result = this.consumer.onSuccess(this.resultArea.remove(action), action);
                }
                catch (Exception e) {
                    cause = e;
                }
                finally {
                    if (cause != null) {
                        this.consumer.onFailure(action, cause);
                    } else if (this.consumer.shouldCallback(result)) {
                        this.resultArea.put(action, result);
                        Producer.this.produce(action);
                    }
                }
            } else {
                try {
                    result = this.consumer.consume(action);
                }
                catch (Exception e) {
                    cause = e;
                }
                finally {
                    if (cause != null) {
                        this.consumer.onFailure(action, cause);
                    } else if (this.consumer.shouldCallback(result)) {
                        this.resultArea.put(action, result);
                        Producer.this.produce(action);
                    }
                }
            }
        }
    }
}

