/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.multithreads.AtomicUnsignedInteger;
import com.github.paganini2008.devtools.multithreads.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

public class ThreadFactoryBuilder {
    private String nameFormat;
    private Boolean daemon;
    private Integer priority;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private ThreadFactory backingThreadFactory;

    public String getNameFormat() {
        return this.nameFormat;
    }

    public ThreadFactoryBuilder setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
        return this;
    }

    public Boolean getDaemon() {
        return this.daemon;
    }

    public ThreadFactoryBuilder setDaemon(Boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public ThreadFactoryBuilder setPriority(Integer priority) {
        if (priority != null) {
            Assert.gt(priority, 10, "Thread priority (%s) must be <= %s", priority, 10);
            Assert.lt(priority, 1, "Thread priority (%s) must be >= %s", priority, 1);
        }
        this.priority = priority;
        return this;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactory getBackingThreadFactory() {
        return this.backingThreadFactory;
    }

    public ThreadFactoryBuilder setBackingThreadFactory(ThreadFactory backingThreadFactory) {
        this.backingThreadFactory = backingThreadFactory;
        return this;
    }

    public ThreadFactory build() {
        final ThreadFactory threadFactory = this.backingThreadFactory != null ? this.backingThreadFactory : new DefaultThreadFactory();
        return new ThreadFactory(){
            final AtomicUnsignedInteger count;
            {
                this.count = ThreadFactoryBuilder.this.nameFormat != null ? new AtomicUnsignedInteger() : null;
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = threadFactory.newThread(r);
                if (thread == null) {
                    throw new IllegalStateException("Null thread object!");
                }
                if (ThreadFactoryBuilder.this.nameFormat != null) {
                    thread.setName(String.format(ThreadFactoryBuilder.this.nameFormat, this.count.getAndIncrement()));
                }
                if (ThreadFactoryBuilder.this.daemon != null) {
                    thread.setDaemon(ThreadFactoryBuilder.this.daemon);
                }
                if (ThreadFactoryBuilder.this.priority != null) {
                    thread.setPriority(ThreadFactoryBuilder.this.priority);
                }
                if (ThreadFactoryBuilder.this.uncaughtExceptionHandler != null) {
                    thread.setUncaughtExceptionHandler(ThreadFactoryBuilder.this.uncaughtExceptionHandler);
                }
                return thread;
            }
        };
    }
}

