/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.CounterLatch;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RecursiveLatch
implements Latch {
    private final Latch delegate;
    private final Lock lock = new ReentrantLock();
    private final ThreadLocal<AtomicInteger> counter = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };

    public RecursiveLatch() {
        this(1);
    }

    public RecursiveLatch(int maxPermits) {
        this(new CounterLatch(maxPermits));
    }

    public RecursiveLatch(Latch delegate) {
        this.delegate = delegate;
    }

    @Override
    public long availablePermits() {
        return this.delegate.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire() {
        this.lock.lock();
        try {
            AtomicInteger threads = this.counter.get();
            boolean acquired = true;
            if (threads.get() == 0) {
                acquired = this.delegate.acquire();
            }
            if (acquired) {
                threads.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAcquire() {
        this.lock.lock();
        try {
            AtomicInteger threads = this.counter.get();
            boolean acquired = true;
            if (threads.get() == 0) {
                acquired = this.delegate.tryAcquire();
            }
            if (acquired) {
                threads.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        this.lock.lock();
        try {
            AtomicInteger threads = this.counter.get();
            boolean acquired = true;
            if (threads.get() == 0) {
                acquired = this.delegate.acquire(timeout, timeUnit);
            }
            if (acquired) {
                threads.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void release() {
        this.lock.lock();
        try {
            AtomicInteger threads = this.counter.get();
            if (threads.get() > 0) {
                threads.decrementAndGet();
            }
            if (threads.get() == 0) {
                this.counter.remove();
                this.delegate.release();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isLocked() {
        return this.delegate.isLocked();
    }

    @Override
    public long join() {
        return this.delegate.join();
    }

    public static void main(String[] args) throws IOException {
        RecursiveLatch latch = new RecursiveLatch(2);
        ThreadPool threads = ThreadUtils.commonPool(10);
        AtomicInteger score = new AtomicInteger();
        for (int i : Sequence.forEach(0, 100)) {
            if (!latch.acquire(1L, TimeUnit.SECONDS)) continue;
            threads.execute(() -> {
                ThreadUtils.randomSleep(500L);
                System.out.println(ThreadUtils.currentThreadName() + ": " + i);
                score.incrementAndGet();
                latch.release();
            });
        }
        latch.join();
        threads.shutdown();
        System.out.println(score);
    }
}

