/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.multithreads.latch;

import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.multithreads.ThreadPool;
import com.github.paganini2008.devtools.multithreads.ThreadUtils;
import com.github.paganini2008.devtools.multithreads.latch.Latch;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SemaphoreLatch
implements Latch {
    private final Semaphore latch;
    private final int maxPermits;
    private final long startTime;

    public SemaphoreLatch() {
        this(1);
    }

    public SemaphoreLatch(int maxPermits) {
        this.latch = new Semaphore(maxPermits);
        this.maxPermits = maxPermits;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public long availablePermits() {
        return this.maxPermits - this.latch.availablePermits();
    }

    @Override
    public boolean tryAcquire() {
        return this.latch.tryAcquire(1);
    }

    @Override
    public boolean acquire() {
        boolean result = true;
        try {
            this.latch.acquire(1);
        }
        catch (InterruptedException e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean acquire(long timeout, TimeUnit timeUnit) {
        boolean result = true;
        try {
            result = this.latch.tryAcquire(1, timeout, timeUnit);
        }
        catch (InterruptedException e) {
            result = false;
        }
        return result;
    }

    @Override
    public void release() {
        if (this.isLocked()) {
            this.latch.release();
        }
    }

    @Override
    public long join() {
        while (this.latch.availablePermits() != this.maxPermits) {
            ThreadUtils.randomSleep(1000L);
        }
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public boolean isLocked() {
        return this.latch.availablePermits() != this.maxPermits;
    }

    public static void main(String[] args) throws IOException {
        SemaphoreLatch latch = new SemaphoreLatch();
        ThreadPool threads = ThreadUtils.commonPool(10);
        AtomicInteger score = new AtomicInteger();
        for (int i : Sequence.forEach(0, 100)) {
            threads.execute(() -> {
                if (latch.acquire(1L, TimeUnit.SECONDS)) {
                    System.out.println(ThreadUtils.currentThreadName() + ": " + i);
                    score.incrementAndGet();
                    latch.release();
                }
            });
        }
        latch.join();
        threads.shutdown();
        System.out.println(score);
    }
}

