/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.primitives;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.NumberUtils;
import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.collection.LruMap;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Floats {
    public static final float[] EMPTY_ARRAY = new float[0];
    public static final Float[] EMPTY_OBJECT_ARRAY = new Float[0];
    private static final LruMap<String, Float> cache = new LruMap(128);
    public static final int BYTES = 4;

    public static void clearCache() {
        cache.clear();
    }

    public static float[] clone(float[] array) {
        return array != null ? (float[])array.clone() : null;
    }

    public static int length(float[] array) {
        return array != null ? array.length : 0;
    }

    public static boolean isFinite(float value) {
        return Float.NEGATIVE_INFINITY < value & value < Float.POSITIVE_INFINITY;
    }

    public static float[][] create(int row, int column) {
        return Floats.create(row, column, 0.0f);
    }

    public static float[][] create(int row, int column, float defaultValue) {
        float[][] array = new float[row][column];
        for (int i = 0; i < row; ++i) {
            array[i] = Floats.create(column, defaultValue);
        }
        return array;
    }

    public static float[] create(int length) {
        return Floats.create(length, 0.0f);
    }

    public static float[] create(int length, float defaultValue) {
        float[] array = new float[length];
        if (defaultValue != 0.0f) {
            for (int i = 0; i < length; ++i) {
                array[i] = defaultValue;
            }
        }
        return array;
    }

    public static boolean isNotEmpty(float[] args) {
        return !Floats.isEmpty(args);
    }

    public static boolean isEmpty(float[] args) {
        return args != null ? args.length == 0 : true;
    }

    public static boolean notContains(float[] a, float b) {
        return !Floats.contains(a, b);
    }

    public static boolean contains(float[] a, float b) {
        return Floats.indexOf(a, b) != -1;
    }

    public static int indexOf(float[] a, float b) {
        return Floats.indexOf(a, b, 0, a.length);
    }

    public static int indexOf(float[] a, float b, int start, int end) {
        if (a == null) {
            return -1;
        }
        if (start < 0) {
            return -1;
        }
        int l = Math.min(a.length, end);
        for (int i = start; i < l; ++i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] a, float b) {
        return Floats.lastIndexOf(a, b, a.length - 1);
    }

    public static int lastIndexOf(float[] a, float b, int start) {
        if (a == null || start < 0) {
            return -1;
        }
        for (int i = Math.min(start, a.length - 1); i >= 0; --i) {
            if (a[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static float[] concat(float[] left, float[] right) {
        Assert.isNull(left, "Left array must not be null.", new Object[0]);
        Assert.isNull(right, "Right array must not be null.", new Object[0]);
        float[] floats = Floats.copy(left, 0, left.length + right.length);
        Floats.hardCopy(right, 0, floats, left.length, right.length);
        return floats;
    }

    public static float[] add(float[] array, float a) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] floats = Floats.copy(array, array.length + 1);
        floats[floats.length - 1] = a;
        return floats;
    }

    public static float[] remove(float[] array, float a) {
        int index = Floats.indexOf(array, a);
        return index != -1 ? Floats.removeAt(array, index) : array;
    }

    public static float[] removeAt(float[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index < 0) {
            index = length - Math.abs(index);
        }
        if (index >= 0 && index < length) {
            float[] target = Floats.create(length - 1, 0.0f);
            Floats.hardCopy(array, 0, target, 0, index);
            Floats.hardCopy(array, index + 1, target, index, length - index - 1);
            return target;
        }
        throw new ArrayIndexOutOfBoundsException("Bad index: " + index);
    }

    public static float[] copy(float[] array) {
        return Floats.copy(array, array.length);
    }

    public static float[] copy(float[] array, int length) {
        return Floats.copy(array, 0, length);
    }

    public static float[] copy(float[] array, int startIndex, int length) {
        return Floats.copy(array, startIndex, length, 0.0f);
    }

    public static float[] copy(float[] array, int startIndex, int length, float defaultValue) {
        float[] target = Floats.create(length, defaultValue);
        Floats.hardCopy(array, startIndex, target, 0, length);
        return target;
    }

    private static void hardCopy(float[] src, int srcFrom, float[] dest, int destFrom, int length) {
        System.arraycopy(src, srcFrom, dest, destFrom, Math.min(src.length, length));
    }

    public static float[] toPrimitives(Byte[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] results = new float[array.length];
        int i = 0;
        for (Byte arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.floatValue();
        }
        return results;
    }

    public static float[] toPrimitives(Short[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] results = new float[array.length];
        int i = 0;
        for (Short arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.floatValue();
        }
        return results;
    }

    public static float[] toPrimitives(Character[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] results = new float[array.length];
        int i = 0;
        for (Character arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.charValue();
        }
        return results;
    }

    public static float[] toPrimitives(Integer[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] results = new float[array.length];
        int i = 0;
        for (Integer arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.floatValue();
        }
        return results;
    }

    public static float[] toPrimitives(Long[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] results = new float[array.length];
        int i = 0;
        for (Long arg : array) {
            if (arg == null) {
                throw new IllegalArgumentException("Null value in array. Index: " + i);
            }
            results[i++] = arg.floatValue();
        }
        return results;
    }

    public static float[] toPrimitives(Float[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int l = array.length;
        float[] results = new float[l];
        int i = 0;
        for (Float arg : array) {
            if (arg == null) continue;
            results[i++] = arg.floatValue();
        }
        return Floats.ensureCapacity(results, i);
    }

    public static float[] ensureCapacity(float[] array, int index) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        if (index != length) {
            return Floats.copy(array, 0, Math.min(index, length));
        }
        return array;
    }

    public static float[] expandCapacity(float[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        return Floats.expandCapacity(array, array.length);
    }

    public static float[] expandCapacity(float[] array, int size) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        int length = array.length;
        return Floats.copy(array, 0, Math.max(length + size, length));
    }

    public static float max(float[] array) {
        Assert.isTrue(Floats.isEmpty(array), "Empty array.", new Object[0]);
        float max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = Floats.max(max, array[i]);
        }
        return max;
    }

    public static float min(float[] array) {
        Assert.isTrue(Floats.isEmpty(array), "Empty array.", new Object[0]);
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = Floats.min(min, array[i]);
        }
        return min;
    }

    public static float sum(float[] array) {
        Assert.isTrue(Floats.isEmpty(array), "Empty array.", new Object[0]);
        float sum = array[0];
        for (int i = 1; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    public static double avg(float[] array) {
        double sum = Floats.sum(array);
        return sum / (double)array.length;
    }

    public static String toString(float[] array) {
        return "[" + Floats.join(array) + "]";
    }

    public static String join(float[] array) {
        return Floats.join(array, ",");
    }

    public static String join(float[] array, String delimiter) {
        if (Floats.isEmpty(array)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder str = new StringBuilder();
        int l = array.length;
        for (int i = 0; i < l; ++i) {
            str.append(array[i]);
            if (i == l - 1) continue;
            str.append(delimiter);
        }
        return str.toString();
    }

    public static String join(float[] left, float[] right, String delimiter) {
        return Floats.join(left, right, delimiter, delimiter);
    }

    public static String join(float[] left, float[] right, String conjunction, String delimiter) {
        if (Floats.isEmpty(left) || Floats.isEmpty(right)) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        int l = Math.min(left.length, right.length);
        for (int i = 0; i < l; ++i) {
            content.append(left[i]).append(conjunction).append(right[i]);
            if (i == l - 1) continue;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void sort(float[] array, int low, int high, boolean asc) {
        for (int i = low; i < high; ++i) {
            for (int j = i; j > low; --j) {
                if (!(asc ? array[j - 1] > array[j] : array[j - 1] < array[j])) continue;
                Floats.swap(array, j - 1, j);
            }
        }
    }

    public static void sort(float[] array, boolean asc) {
        if (Floats.isNotEmpty(array)) {
            float[] aux = (float[])array.clone();
            Floats.mergeSort(aux, array, 0, array.length, asc);
        }
    }

    private static void mergeSort(float[] src, float[] dest, int low, int high, boolean asc) {
        int length = high - low;
        if (length < 10) {
            Floats.sort(dest, low, high, asc);
            return;
        }
        int mid = (high + low) / 2;
        Floats.mergeSort(dest, src, low, mid, asc);
        Floats.mergeSort(dest, src, mid, high, asc);
        int i = low;
        int p = low;
        int q = mid;
        while (p < mid && q < high) {
            if (asc ? src[p] <= src[q] : src[p] > src[q]) {
                dest[i++] = src[p++];
                continue;
            }
            dest[i++] = src[q++];
        }
        while (p < mid && i < high) {
            dest[i++] = src[p++];
        }
        while (q < high && i < high) {
            dest[i++] = src[q++];
        }
    }

    public static float[] unionAll(float[] left, float[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        float[] total = new float[left.length + right.length];
        int i = 0;
        for (float s : left) {
            total[i++] = s;
        }
        for (float s : right) {
            total[i++] = s;
        }
        return Floats.ensureCapacity(total, i);
    }

    public static float[] union(float[] left, float[] right) {
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        float[] total = new float[left.length + right.length];
        int i = 0;
        for (float s : left) {
            if (Floats.contains(total, s)) continue;
            total[i++] = s;
        }
        for (float s : right) {
            if (Floats.contains(total, s)) continue;
            total[i++] = s;
        }
        return Floats.ensureCapacity(total, i);
    }

    public static float[] minus(float[] left, float[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        float[] result = new float[right.length];
        for (i = 0; i < left.length; ++i) {
            if (Floats.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Floats.ensureCapacity(result, i);
    }

    public static float[] intersect(float[] left, float[] right) {
        int i;
        if (left == null && right == null) {
            return null;
        }
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        float[] result = new float[right.length];
        for (i = 0; i < left.length; ++i) {
            if (!Floats.contains(right, left[i])) continue;
            result[i++] = left[i];
        }
        return Floats.ensureCapacity(result, i);
    }

    public static float[] toArray(Collection<?> collection) {
        Assert.isNull(collection, "Source collection must not be null.", new Object[0]);
        float[] array = new float[collection.size()];
        int i = 0;
        for (Object a : collection) {
            try {
                array[i++] = ((Number)a).floatValue();
            }
            catch (RuntimeException runtimeException) {}
        }
        return Floats.ensureCapacity(array, i);
    }

    public static List<Float> toList(float[] array) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        ArrayList<Float> set = new ArrayList<Float>(array.length);
        for (float a : array) {
            set.add(Float.valueOf(a));
        }
        return set;
    }

    public static void reverse(float[] src) {
        int l = src.length;
        for (int i = 0; i < l / 2; ++i) {
            float a;
            float t = src[i];
            int j = l - 1 - i;
            src[i] = a = src[j];
            src[j] = t;
        }
    }

    public static int hashCode(float arg) {
        return Float.valueOf(arg).hashCode();
    }

    public static boolean deepEquals(float[] left, float[] right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        int length = left.length;
        if (length != right.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    public static Float valueOf(Character c) {
        return Floats.valueOf(c, null);
    }

    public static Float valueOf(Character c, Float defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return Floats.valueOf(String.valueOf(c), defaultValue);
    }

    public static Float valueOf(Boolean b) {
        return Floats.valueOf(b, null);
    }

    public static Float valueOf(Boolean b, Float defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return Float.valueOf(Floats.cast(b));
    }

    public static Float valueOf(String str) {
        return Floats.valueOf(str, null);
    }

    public static Float valueOf(String str, Float defaultValue) {
        if (StringUtils.isBlank(str)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Floats.parse(str));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Float[] valueOf(String[] strings) {
        return Floats.valueOf(strings, null);
    }

    public static Float[] valueOf(String[] strings, Float defaultValue) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[strings.length];
        int i = 0;
        for (String str : strings) {
            result[i++] = Floats.valueOf(str, defaultValue);
        }
        return result;
    }

    public static float[] parseMany(String[] strings) {
        return Floats.parseMany(strings, true);
    }

    public static float[] parseMany(String[] strings, boolean thrown) {
        Assert.isNull(strings, "Source array must not be null.", new Object[0]);
        float[] result = new float[strings.length];
        int i = 0;
        for (String str : strings) {
            try {
                result[i++] = Floats.parse(str);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Floats.ensureCapacity(result, i);
    }

    public static float parse(String str) {
        Assert.hasNoText(str, "Number string must not be null.", new Object[0]);
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException numberFormatException) {
            return Floats.parseStrictly(str);
        }
    }

    private static float parseStrictly(String str) {
        Float pooled = cache.get(str);
        if (pooled == null) {
            String newStr = NumberUtils.read(str);
            if (!NumberUtils.isNumber(newStr)) {
                throw new NumberFormatException("Can not parse string for: " + str);
            }
            cache.put(str, Float.valueOf(Float.parseFloat(newStr)));
            pooled = cache.get(str);
        }
        return pooled.floatValue();
    }

    public static float cast(boolean b) {
        return b ? 1.0f : 0.0f;
    }

    public static float[] casts(boolean[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        int i = 0;
        for (boolean val : value) {
            result[i++] = Floats.cast(val);
        }
        return result;
    }

    public static float cast(char value) {
        return value;
    }

    public static float[] casts(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        int i = 0;
        for (char val : value) {
            result[i++] = Floats.cast(val);
        }
        return result;
    }

    public static float[] casts(double[] value) {
        return Floats.casts(value, true);
    }

    public static float[] casts(double[] value, boolean thrown) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        int i = 0;
        for (double val : value) {
            try {
                result[i++] = Floats.cast(val);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return result;
    }

    public static float cast(Number n) {
        Assert.isNull(n, "Number is required.", new Object[0]);
        return n.floatValue();
    }

    public static float[] casts(Number[] array) {
        return Floats.casts(array, true);
    }

    public static float[] casts(Number[] array, boolean thrown) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        float[] result = new float[array.length];
        int i = 0;
        for (Number n : array) {
            try {
                result[i++] = Floats.cast(n);
            }
            catch (IllegalArgumentException e) {
                if (!thrown) continue;
                throw e;
            }
        }
        return Floats.ensureCapacity(result, i);
    }

    public static Float valueOf(Number n, Float defaultValue) {
        if (n == null) {
            return defaultValue;
        }
        if (n instanceof Float) {
            return (Float)n;
        }
        try {
            return Float.valueOf(Floats.cast(n));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static Float[] valueOf(Number[] array) {
        return Floats.valueOf(array, null);
    }

    public static Float[] valueOf(Number[] array, Float defaultValue) {
        Assert.isNull(array, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[array.length];
        int i = 0;
        for (Number arg : array) {
            result[i++] = Floats.valueOf(arg, defaultValue);
        }
        return result;
    }

    public static Float[] toWrappers(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Float.valueOf(value[i]);
        }
        return result;
    }

    public static Float[] toWrappers(char[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Float.valueOf(value[i]);
        }
        return result;
    }

    public static Float[] toWrappers(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Float.valueOf(value[i]);
        }
        return result;
    }

    public static Float[] toWrappers(float[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Float.valueOf(value[i]);
        }
        return result;
    }

    public static Float[] toWrappers(int[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Float.valueOf(value[i]);
        }
        return result;
    }

    public static Float[] toWrappers(long[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        Float[] result = new Float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = Float.valueOf(value[i]);
        }
        return result;
    }

    public static float[] casts(byte[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static float[] casts(short[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static float[] casts(int[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static float[] casts(long[] value) {
        Assert.isNull(value, "Source array must not be null.", new Object[0]);
        float[] result = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = value[i];
        }
        return result;
    }

    public static int deepHashCode(float[] args) {
        Assert.isNull(args, "Source array must not be null.", new Object[0]);
        int hash = 0;
        for (int i = 0; i < args.length; ++i) {
            hash += Floats.hashCode(args[i]);
        }
        return hash;
    }

    public static float toFixed(float value, int scale) {
        return Float.parseFloat(NumberUtils.format((Number)Float.valueOf(value), scale));
    }

    public static String toPlainString(float value) {
        return BigDecimal.valueOf(value).toPlainString();
    }

    public static String[] toStringArray(float[] args, DecimalFormat df) {
        int l = args.length;
        String[] array = new String[l];
        for (int i = 0; i < l; ++i) {
            array[i] = df != null ? df.format(args[i]) : Floats.toPlainString(args[i]);
        }
        return array;
    }

    public static boolean isSameLength(float[] left, float[] right) {
        if (left == null) {
            return right != null ? right.length == 0 : true;
        }
        if (right == null) {
            return left != null ? left.length == 0 : true;
        }
        return left.length == right.length;
    }

    public static boolean same(float[] array) {
        return Floats.isSerial(array, 0.0f);
    }

    public static boolean isSerial(float[] array, float n) {
        if (Floats.isEmpty(array)) {
            return false;
        }
        for (int i = array.length - 1; i > 0; --i) {
            if (array[i] - array[i - 1] == n) continue;
            return false;
        }
        return true;
    }

    public static boolean isSubarray(float[] left, float[] right) {
        if (Floats.isEmpty(left) || Floats.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] != right[0]) continue;
            boolean f = true;
            for (int j = 1; j < right.length; ++j) {
                if (i + j == left.length) {
                    return false;
                }
                if (left[i + j] == right[j]) continue;
                f = false;
                break;
            }
            if (!f) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(float[] left, float[] right) {
        if (Floats.isEmpty(left) || Floats.isEmpty(right) || left.length < right.length) {
            return false;
        }
        for (float f : right) {
            if (!Floats.notContains(left, f)) continue;
            return false;
        }
        return true;
    }

    public static void leftScroll(float[] src, int n) {
        if (Floats.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Floats.rightScroll(src, l - n);
        }
    }

    public static void rightScroll(float[] src, int n) {
        if (Floats.isNotEmpty(src) && n > 0) {
            int l = src.length;
            Floats.rightScroll(src, 0, l - (n %= l) - 1);
            Floats.rightScroll(src, l - n, l - 1);
            Floats.rightScroll(src, 0, l - 1);
        }
    }

    private static void rightScroll(float[] src, int n, int m) {
        while (n < m) {
            Floats.swap(src, m, n);
            ++n;
            --m;
        }
    }

    public static float max(float a, float b) {
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Math.max(a, b);
    }

    public static float min(float a, float b) {
        if (Float.isNaN(a)) {
            return b;
        }
        if (Float.isNaN(b)) {
            return a;
        }
        return Math.min(a, b);
    }

    public static boolean between(float val, float start, float end) {
        return Floats.compare(val, start) >= 0 && Floats.compare(val, end) <= 0;
    }

    public static boolean rightIn(float val, float start, float end) {
        return Floats.compare(val, start) >= 0 && Floats.compare(val, end) < 0;
    }

    public static boolean leftIn(float val, float start, float end) {
        return Floats.compare(val, start) > 0 && Floats.compare(val, end) <= 0;
    }

    public static boolean in(float val, float start, float end) {
        return Floats.compare(val, start) > 0 && Floats.compare(val, end) < 0;
    }

    public static void shuffle(float[] src) {
        Floats.shuffle(src, ThreadLocalRandom.current());
    }

    public static void shuffle(float[] src, Random rn) {
        for (int i = src.length; i > 1; --i) {
            Floats.swap(src, i - 1, rn.nextInt(i));
        }
    }

    public static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    public static Comparator<float[]> defaultComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    private static enum LexicographicalComparator implements Comparator<float[]>
    {
        INSTANCE;


        @Override
        public int compare(float[] left, float[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Floats.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }
}

