/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.reflection;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.reflection.ReflectionException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class ConstructorUtils {
    private ConstructorUtils() {
    }

    public static <T> T invokeConstructor(Class<T> cl, Object ... arugments) {
        if (arugments == null) {
            arugments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        Class[] parameterTypes = new Class[arugments.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = arugments[i].getClass();
        }
        return ConstructorUtils.invokeConstructor(cl, parameterTypes, arugments);
    }

    public static <T> T invokeConstructor(Class<T> cl, Class<?>[] parameterTypes, Object ... arugments) {
        Constructor<T> method = ConstructorUtils.getConstructor(cl, parameterTypes);
        return ConstructorUtils.invokeConstructor(method, arugments);
    }

    public static <T> T invokeConstructor(Constructor<T> method, Object ... arugments) {
        if (arugments == null) {
            arugments = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        try {
            method.setAccessible(true);
            return method.newInstance(arugments);
        }
        catch (Exception e) {
            throw new ReflectionException("Invoke constructor failed by name: " + method.getName(), e);
        }
    }

    public static <T> Constructor<T> getConstructorIfAbsent(Class<T> type, Class<?> ... parameterTypes) {
        try {
            return ConstructorUtils.getConstructor(type, parameterTypes);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        Assert.isNull(type, "Class must not be null.", new Object[0]);
        if (parameterTypes == null) {
            parameterTypes = ClassUtils.EMPTY_ARRAY;
        }
        try {
            return type.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            Exception cause = e;
            if (cause instanceof NoSuchMethodException) {
                try {
                    return ConstructorUtils.searchConstructor(type, type.getDeclaredConstructors(), parameterTypes);
                }
                catch (NoSuchMethodException e2) {
                    cause = e2;
                }
            }
            try {
                type.getConstructor(parameterTypes);
            }
            catch (Exception e3) {
                cause = e3;
            }
            if (cause instanceof NoSuchMethodException) {
                try {
                    return ConstructorUtils.searchConstructor(type, type.getConstructors(), parameterTypes);
                }
                catch (NoSuchMethodException e4) {
                    cause = e4;
                }
            }
            throw new ReflectionException(cause);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <T> Constructor<T> searchConstructor(Class<T> cls, Constructor<?>[] methods, Class<?>[] parameterTypes) throws NoSuchMethodException {
        if (methods != null) {
            void var6_8;
            ArrayList candidates = new ArrayList();
            Constructor<?>[] constructorArray = methods;
            int n = constructorArray.length;
            boolean bl = false;
            while (var6_8 < n) {
                Constructor<?> constructor = constructorArray[var6_8];
                if (ClassUtils.isAssignable(constructor.getParameterTypes(), parameterTypes)) {
                    candidates.add(constructor);
                }
                ++var6_8;
            }
            if (!candidates.isEmpty()) {
                Constructor bestMatch = (Constructor)candidates.get(0);
                for (Constructor constructor : candidates) {
                    if (!ClassUtils.equals(constructor.getParameterTypes(), parameterTypes)) continue;
                    bestMatch = constructor;
                }
                return bestMatch;
            }
        }
        throw new NoSuchMethodException("No matched constructor: " + cls.getSimpleName() + "(" + ArrayUtils.toString(parameterTypes) + ") on class: " + cls.getName());
    }
}

