/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.reflection;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ClassUtils;
import com.github.paganini2008.devtools.collection.CollectionUtils;
import com.github.paganini2008.devtools.reflection.FieldFilter;
import com.github.paganini2008.devtools.reflection.ReflectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;

public abstract class FieldUtils {
    public static Object readField(Object target, Field field) {
        Assert.isNull(target, "Target object must not be null.", new Object[0]);
        Assert.isNull(field, "The field must not be null.", new Object[0]);
        try {
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot read field by name: " + field.getName(), e);
        }
    }

    public static Object readStaticField(Field field) {
        Assert.isNull(field, "The field must not be null.", new Object[0]);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static");
        }
        try {
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot read static field by name: " + field.getName(), e);
        }
    }

    public static Object readField(Object target, String fieldName) {
        Assert.isNull(target, "Target object must not be null.", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, fieldName);
        return FieldUtils.readField(target, field);
    }

    public static Object readDeclaredField(Object target, String fieldName) {
        Assert.isNull(target, "Target object must not be null.", new Object[0]);
        Field field = FieldUtils.getDeclaredField(target.getClass(), fieldName);
        return FieldUtils.readField(target, field);
    }

    public static Object readStaticField(Class<?> type, String fieldName) {
        Field field = FieldUtils.getField(type, fieldName);
        return FieldUtils.readStaticField(field);
    }

    public static Object readDeclaredStaticField(Class<?> type, String fieldName) {
        Field field = FieldUtils.getDeclaredField(type, fieldName);
        return FieldUtils.readStaticField(field);
    }

    public static void writeField(Object target, Field field, Object value) {
        Assert.isNull(target, "Target object must not be null.", new Object[0]);
        Assert.isNull(field, "The field must not be null.", new Object[0]);
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot read field by name: " + field.getName(), e);
        }
    }

    public static void writeStaticField(Field field, Object value) {
        Assert.isNull(field, "The field must not be null.", new Object[0]);
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException("The field '" + field.getName() + "' is not static.");
        }
        try {
            field.setAccessible(true);
            field.set(null, value);
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot read field by name: " + field.getName(), e);
        }
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value) {
        Assert.isNull(target, "Target object must not be null.", new Object[0]);
        Field field = FieldUtils.getDeclaredField(target.getClass(), fieldName);
        FieldUtils.writeField(target, field, value);
    }

    public static void writeField(Object target, String fieldName, Object value) {
        Assert.isNull(target, "Target object must not be null.", new Object[0]);
        Field field = FieldUtils.getField(target.getClass(), fieldName);
        FieldUtils.writeField(target, field, value);
    }

    public static void writeStaticField(Class<?> type, String fieldName, Object value) {
        Field field = FieldUtils.getField(type, fieldName);
        FieldUtils.writeStaticField(field, value);
    }

    public static void writeDeclaredStaticField(Class<?> type, String fieldName, Object value) {
        Field field = FieldUtils.getDeclaredField(type, fieldName);
        FieldUtils.writeStaticField(field, value);
    }

    public static Field getFieldIfAbsent(Class<?> cls, String fieldName) {
        try {
            return FieldUtils.getField(cls, fieldName);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static Field getField(Class<?> type, String fieldName) {
        Assert.isNull(type, "The class must not be null.", new Object[0]);
        Assert.hasNoText(fieldName, "The field name must not be null.", new Object[0]);
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return FieldUtils.searchField(type, fieldName);
        }
    }

    private static Field searchField(Class<?> type, String fieldName) {
        try {
            return type.getField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Iterator<Class<?>> it = ClassUtils.getAllInterfaces(type).iterator();
            while (it.hasNext()) {
                try {
                    Field match = it.next().getField(fieldName);
                    if (match == null) continue;
                    return match;
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                }
            }
            throw new ReflectionException("Cannot find field " + type.getName() + "." + fieldName);
        }
    }

    public static Field getDeclaredField(Class<?> type, String fieldName) {
        Assert.isNull(type, "The class must not be null.", new Object[0]);
        Assert.hasNoText(fieldName, "The field name must not be null", new Object[0]);
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException("Cannot find declared field " + type.getName() + "." + fieldName);
        }
    }

    public static List<Field> getDeclaredFields(Class<?> cls, FieldFilter fieldFilter) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : CollectionUtils.forEach(new DeclaredFieldIterator(cls))) {
            if (fieldFilter != null && !fieldFilter.accept(field.getName(), field)) continue;
            fields.add(field);
        }
        return fields;
    }

    public static List<Field> getFields(Class<?> cls, FieldFilter fieldFilter) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : CollectionUtils.forEach(new FieldIterator(cls))) {
            if (fieldFilter != null && !fieldFilter.accept(field.getName(), field)) continue;
            fields.add(field);
        }
        return fields;
    }

    public static void main(String[] args) {
        FieldIterator iterator = new FieldIterator(AbstractAction.class);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public static class FieldIterator
    implements Iterator<Field> {
        private final Iterator<Class<?>> superClassesAndInterfaces;
        private Iterator<Field> fields;

        FieldIterator(Class<?> type) {
            this.fields = new DeclaredFieldIterator(type);
            this.superClassesAndInterfaces = ClassUtils.getAllSuperClassesAndInterfaces(type).iterator();
        }

        @Override
        public boolean hasNext() {
            boolean next = this.canContinue();
            if (!next) {
                this.fields = this.superClassesAndInterfaces.hasNext() ? new DeclaredFieldIterator(this.superClassesAndInterfaces.next()) : null;
                next = this.canContinue();
            }
            return next;
        }

        private boolean canContinue() {
            return this.fields != null && this.fields.hasNext();
        }

        @Override
        public Field next() {
            return this.fields.next();
        }
    }

    public static class DeclaredFieldIterator
    implements Iterator<Field> {
        private Iterator<Class<?>> interfaces;
        private Iterator<Field> fields;

        DeclaredFieldIterator(Class<?> type) {
            this.fields = CollectionUtils.iterator(type.getDeclaredFields());
            this.interfaces = CollectionUtils.iterator(type.getInterfaces());
        }

        @Override
        public boolean hasNext() {
            boolean next = this.canContinue();
            if (!next) {
                this.fields = this.interfaces.hasNext() ? CollectionUtils.iterator(this.interfaces.next().getDeclaredFields()) : null;
                next = this.canContinue();
            }
            return next;
        }

        private boolean canContinue() {
            return this.fields != null && this.fields.hasNext();
        }

        @Override
        public Field next() {
            return this.fields.next();
        }
    }
}

