/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.CaseFormat;
import java.util.function.Function;

public abstract class CaseFormats {
    public static final CaseFormat LOWER_HYPHEN = new LowerHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '-');
    public static final CaseFormat UPPER_HYPHEN = new UpperHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '-');
    public static final CaseFormat LOWER_UNDERSCORE = new LowerHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '_');
    public static final CaseFormat UPPER_UNDERSCORE = new UpperHyphenCase(ch -> Character.isUpperCase(ch.charValue()), '_');
    public static final CaseFormat LOWER_CAMEL = new LowerCamelCase(ch -> ch.charValue() == '-' || ch.charValue() == '_');
    public static final CaseFormat UPPER_CAMEL = new UpperCamelCase(ch -> ch.charValue() == '-' || ch.charValue() == '_');

    public static class LowerCamelCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;

        public LowerCamelCase(Function<Character, Boolean> f) {
            this.f = f;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            StringBuilder content = new StringBuilder();
            boolean start = false;
            boolean upperCase = false;
            int l = str.length();
            for (int i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (!start && Character.isAlphabetic(c)) {
                    start = true;
                }
                if (!start) continue;
                if (this.f.apply(Character.valueOf(c)).booleanValue()) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    c = Character.toUpperCase(c);
                    upperCase = false;
                }
                content.append(c);
            }
            char firstChar = content.charAt(0);
            if (!Character.isLowerCase(firstChar)) {
                content.setCharAt(0, Character.toLowerCase(firstChar));
            }
            return content.toString();
        }
    }

    public static class UpperCamelCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;

        public UpperCamelCase(Function<Character, Boolean> f) {
            this.f = f;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            StringBuilder content = new StringBuilder();
            boolean start = false;
            boolean upperCase = false;
            int l = str.length();
            for (int i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (!start && Character.isAlphabetic(c)) {
                    start = true;
                    upperCase = true;
                }
                if (!start) continue;
                if (this.f.apply(Character.valueOf(c)).booleanValue()) {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    c = Character.toUpperCase(c);
                    upperCase = false;
                }
                content.append(c);
            }
            return content.toString();
        }
    }

    public static class LowerHyphenCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;
        private final char hyphen;

        public LowerHyphenCase(Function<Character, Boolean> f, char hyphen) {
            this.f = f;
            this.hyphen = hyphen;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            StringBuilder content = new StringBuilder();
            boolean start = false;
            int l = str.length();
            for (int i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (!start && Character.isAlphabetic(c)) {
                    start = true;
                }
                if (!start) continue;
                if (this.f.apply(Character.valueOf(c)).booleanValue()) {
                    content.append(this.hyphen);
                }
                content.append(Character.toLowerCase(c));
            }
            if (content.length() == 0) {
                content.append(str);
            }
            return content.toString();
        }
    }

    public static class UpperHyphenCase
    implements CaseFormat {
        private final Function<Character, Boolean> f;
        private final char hyphen;

        public UpperHyphenCase(Function<Character, Boolean> f, char hyphen) {
            this.f = f;
            this.hyphen = hyphen;
        }

        @Override
        public String toCase(CharSequence str) {
            Assert.hasNoText(str);
            StringBuilder content = new StringBuilder();
            boolean start = false;
            int l = str.length();
            for (int i = 0; i < l; ++i) {
                char c = str.charAt(i);
                if (!start && Character.isAlphabetic(c)) {
                    start = true;
                }
                if (!start) continue;
                if (this.f.apply(Character.valueOf(c)).booleanValue()) {
                    content.append(this.hyphen);
                }
                content.append(Character.toUpperCase(c));
            }
            if (content.length() == 0) {
                content.append(str);
            }
            return content.toString();
        }
    }
}

