/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;

public abstract class Comparables {
    public static <T> T nullOrMax(T leftValue, T rightValue) {
        return leftValue == null ? rightValue : leftValue;
    }

    public static <T> T nullOrMin(T leftValue, T rightValue) {
        return leftValue == null ? leftValue : rightValue;
    }

    public static <T extends Comparable<T>> T getOrDefault(T left, T right) {
        return Comparables.getOrDefault(left, right, null);
    }

    public static <T extends Comparable<T>> T getOrDefault(T left, T right, T defaultValue) {
        if (Comparables.compareTo(left, right) == 0) {
            return defaultValue;
        }
        return left;
    }

    public static <T extends Comparable<T>> T minOrDefault(T left, T right, T defaultValue) {
        if (Comparables.compareTo(left, right) == 0) {
            return defaultValue;
        }
        return Comparables.min(left, defaultValue);
    }

    public static <T extends Comparable<T>> T maxOrDefault(T left, T right, T defaultValue) {
        if (Comparables.compareTo(left, right) == 0) {
            return defaultValue;
        }
        return Comparables.max(left, defaultValue);
    }

    public static <T extends Comparable<T>> T max(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return null;
        }
        T max = array[0];
        for (T t : array) {
            max = Comparables.max(max, t);
        }
        return max;
    }

    public static <T extends Comparable<T>> T min(T[] array) {
        if (ArrayUtils.isEmpty(array)) {
            return null;
        }
        T min = array[0];
        for (T t : array) {
            min = Comparables.min(min, t);
        }
        return min;
    }

    public static <T extends Comparable<T>> T max(T a, T b) {
        return Comparables.compareTo(a, b) >= 0 ? a : b;
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        return Comparables.compareTo(a, b) <= 0 ? a : b;
    }

    public static <T extends Comparable<T>> boolean between(T value, T minValue, T maxValue) {
        return Comparables.gte(value, minValue) && Comparables.lte(value, maxValue);
    }

    public static <T extends Comparable<T>> boolean ne(T left, T right) {
        return Comparables.compareTo(left, right) != 0;
    }

    public static <T extends Comparable<T>> boolean eq(T left, T right) {
        return Comparables.compareTo(left, right) == 0;
    }

    public static <T extends Comparable<T>> boolean gte(T left, T right) {
        return Comparables.compareTo(left, right) >= 0;
    }

    public static <T extends Comparable<T>> boolean gt(T left, T right) {
        return Comparables.compareTo(left, right) > 0;
    }

    public static <T extends Comparable<T>> boolean lte(T left, T right) {
        return Comparables.compareTo(left, right) <= 0;
    }

    public static <T extends Comparable<T>> boolean lt(T left, T right) {
        return Comparables.compareTo(left, right) < 0;
    }

    public static <T extends Comparable<T>> int compareTo(T left, T right) {
        if (left == null && right != null) {
            return -1;
        }
        if (left != null && right == null) {
            return 1;
        }
        if (left != null && right != null) {
            return Comparables.compareResult(left.compareTo(right));
        }
        return 0;
    }

    private static <T extends Comparable<T>> int compareResult(int result) {
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }
}

