/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.io.IOUtils;
import com.github.paganini2008.devtools.io.StringArrayWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;

public abstract class ExceptionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] toArray(Throwable e) {
        if (e == null) {
            return new String[0];
        }
        String[] array = null;
        PrintWriter writer = null;
        try {
            StringArrayWriter out = new StringArrayWriter();
            writer = new PrintWriter(out);
            e.printStackTrace(writer);
            array = out.toArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        ArrayList<String> results = new ArrayList<String>();
        for (String line : array) {
            if (line.equals(IOUtils.NEWLINE)) continue;
            if (line.startsWith("\t")) {
                line = line.replace("\t", "    ");
            }
            results.add(line);
        }
        return results.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Throwable e) {
        String string;
        PrintWriter writer = null;
        try {
            StringWriter out = new StringWriter();
            writer = new PrintWriter(out);
            e.printStackTrace(writer);
            string = out.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly(writer);
        return string;
    }

    public static boolean ignoreException(Throwable e, Class<?>[] exceptionClasses) {
        if (ArrayUtils.isNotEmpty(exceptionClasses)) {
            for (Class<?> exceptionClass : exceptionClasses) {
                if (!exceptionClass.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        return false;
    }
}

