/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.StringUtils;
import com.github.paganini2008.devtools.TokenParser;
import java.util.function.Function;

public class PlaceholderTokenParser
implements TokenParser<String, String> {
    private final String prefix;
    private final String suffix;

    public PlaceholderTokenParser(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String parse(String text, Function<String, Object> function) {
        int offset = 0;
        int start = text.indexOf(this.prefix, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        char[] src = text.toCharArray();
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(this.prefix);
                offset = start + this.prefix.length();
            } else {
                int end = text.indexOf(this.suffix, start);
                if (end == -1) {
                    builder.append(src, offset, src.length - offset);
                    offset = src.length;
                } else {
                    builder.append(src, offset, start - offset);
                    offset = start + this.prefix.length();
                    String part = new String(src, offset, end - offset);
                    if (StringUtils.isNotBlank(part)) {
                        Object value = function.apply(part);
                        if (value == null) {
                            value = System.getProperty(part);
                        }
                        builder.append(value);
                    }
                    offset = end + this.suffix.length();
                }
            }
            start = text.indexOf(this.prefix, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }
}

