/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.RandomUtils;
import com.github.paganini2008.devtools.Sequence;
import com.github.paganini2008.devtools.primitives.Chars;
import java.util.ArrayList;

public abstract class RandomStringUtils {
    private static final char[] LETTERS_LOWER;
    private static final char[] LETTERS_UPPER;
    private static final char[] LETTERS;
    private static final char[] DIGITS;
    private static final char[] DIGITS_LETTERS_LOWER;
    private static final char[] DIGITS_LETTERS_UPPER;
    private static final char[] DIGITS_LETTERS;

    public static void main(String[] args) throws Exception {
        for (String s : RandomStringUtils.randomStrings(10000, 100, true, true, true)) {
            System.out.println(s);
        }
    }

    public static String randomString(int count) {
        return RandomStringUtils.randomString(count, true, true, true);
    }

    public static String randomString(int count, boolean digits, boolean lowerCaseLetters, boolean upperCaseLetters) {
        return RandomStringUtils.randomString(count, RandomStringUtils.getExample(digits, lowerCaseLetters, upperCaseLetters));
    }

    public static String randomString(int count, String example) {
        return RandomStringUtils.randomString(count, example.toCharArray());
    }

    public static String randomString(int count, char[] chars) {
        return RandomStringUtils.randomString(count, chars, 0);
    }

    public static String randomString(int count, String example, int from) {
        return RandomStringUtils.randomString(count, example.toCharArray(), from);
    }

    public static String randomString(int count, char[] chars, int from) {
        return RandomStringUtils.randomString(count, chars, from, chars.length);
    }

    public static String randomString(int count, String example, int from, int to) {
        return RandomStringUtils.randomString(count, example.toCharArray(), from, to);
    }

    public static String randomString(int count, char[] chars, int from, int to) {
        char[] buffer = new char[count];
        for (int i = 0; i < count; ++i) {
            buffer[i] = chars[RandomUtils.randomInt(from, to)];
        }
        return new String(buffer);
    }

    public static String[] randomStrings(int length, int count) {
        return RandomStringUtils.randomStrings(length, count, true, true, true);
    }

    public static String[] randomStrings(int length, int count, boolean digits, boolean lowerCaseLetters, boolean upperCaseLetters) {
        return RandomStringUtils.randomStrings(length, count, RandomStringUtils.getExample(digits, lowerCaseLetters, upperCaseLetters));
    }

    public static String[] randomStrings(int length, int count, String example) {
        return RandomStringUtils.randomStrings(length, count, example, 0);
    }

    public static String[] randomStrings(int length, int count, String example, int from) {
        return RandomStringUtils.randomStrings(length, count, example.toCharArray(), from);
    }

    public static String[] randomStrings(int length, int count, String example, int from, int to) {
        return RandomStringUtils.randomStrings(length, count, example.toCharArray(), from, to);
    }

    public static String[] randomStrings(int length, int count, char[] chars) {
        return RandomStringUtils.randomStrings(length, count, chars, 0);
    }

    public static String[] randomStrings(int length, int count, char[] chars, int from) {
        return RandomStringUtils.randomStrings(length, count, chars, from, chars.length);
    }

    public static String[] randomStrings(int length, int count, char[] chars, int from, int to) {
        Object[] results = new String[length];
        for (int i = 0; i < length; ++i) {
            String rs;
            while (ArrayUtils.contains(results, rs = RandomStringUtils.randomString(count, chars, from, to))) {
            }
            results[i] = rs;
        }
        return results;
    }

    private static char[] getExample(boolean digits, boolean lowerCaseLetters, boolean upperCaseLetters) {
        char[] ch = Chars.EMPTY_ARRAY;
        if (digits && lowerCaseLetters && upperCaseLetters) {
            ch = DIGITS_LETTERS;
        } else if (digits && lowerCaseLetters && !upperCaseLetters) {
            ch = DIGITS_LETTERS_LOWER;
        } else if (digits && !lowerCaseLetters && upperCaseLetters) {
            ch = DIGITS_LETTERS_UPPER;
        } else if (!digits && lowerCaseLetters && upperCaseLetters) {
            ch = LETTERS;
        } else if (digits && !lowerCaseLetters && !upperCaseLetters) {
            ch = DIGITS;
        } else if (!digits && lowerCaseLetters && !upperCaseLetters) {
            ch = LETTERS_LOWER;
        } else if (!digits && !lowerCaseLetters && upperCaseLetters) {
            ch = LETTERS_UPPER;
        }
        return (char[])ch.clone();
    }

    static {
        ArrayList<Character> lettersLower = new ArrayList<Character>();
        ArrayList<Character> lettersUpper = new ArrayList<Character>();
        ArrayList<Character> letters = new ArrayList<Character>();
        ArrayList<Character> digits = new ArrayList<Character>();
        ArrayList<Character> digitsLettersLower = new ArrayList<Character>();
        ArrayList<Character> digitsLettersUpper = new ArrayList<Character>();
        ArrayList<Character> digitsLetters = new ArrayList<Character>();
        for (int i : Sequence.forEach(97, 122)) {
            lettersLower.add(Character.valueOf((char)i));
        }
        for (int i : Sequence.forEach(65, 90)) {
            lettersUpper.add(Character.valueOf((char)i));
        }
        for (int i : Sequence.forEach(48, 57)) {
            digits.add(Character.valueOf((char)i));
        }
        letters.addAll(lettersLower);
        letters.addAll(lettersUpper);
        digitsLettersLower.addAll(digits);
        digitsLettersLower.addAll(lettersLower);
        digitsLettersUpper.addAll(digits);
        digitsLettersUpper.addAll(lettersUpper);
        digitsLetters.addAll(letters);
        digitsLetters.addAll(digits);
        LETTERS_LOWER = Chars.toArray(lettersLower);
        LETTERS_UPPER = Chars.toArray(lettersUpper);
        LETTERS = Chars.toArray(letters);
        DIGITS = Chars.toArray(digits);
        DIGITS_LETTERS_LOWER = Chars.toArray(digitsLettersLower);
        DIGITS_LETTERS_UPPER = Chars.toArray(digitsLettersUpper);
        DIGITS_LETTERS = Chars.toArray(digitsLetters);
    }
}

