/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools;

import com.github.paganini2008.devtools.ArrayUtils;
import com.github.paganini2008.devtools.StringUtils;
import java.util.ArrayList;

public class TableView {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final String[][] array;

    public TableView(int rowNumber, int columnNumber) {
        this(rowNumber, columnNumber, 1);
    }

    public TableView(int rowNumber, int columnNumber, int width) {
        this.array = ArrayUtils.newArray(String.class, rowNumber, columnNumber, StringUtils.repeat(' ', width));
    }

    public TableView setValues(int rowIndex, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.setValue(rowIndex, i, values[i]);
        }
        return this;
    }

    public TableView setValue(int rowIndex, int columnIndex, String value) {
        int width = this.array[rowIndex][columnIndex].length();
        this.array[rowIndex][columnIndex] = StringUtils.textMiddle(value, width);
        return this;
    }

    public TableView setValueOnLeft(int rowIndex, int columnIndex, String value, int padding) {
        int width = this.array[rowIndex][columnIndex].length();
        this.array[rowIndex][columnIndex] = StringUtils.textLeft(value, padding, width);
        return this;
    }

    public TableView setValueOnRight(int rowIndex, int columnIndex, String value, int padding) {
        int width = this.array[rowIndex][columnIndex].length();
        this.array[rowIndex][columnIndex] = StringUtils.textRight(value, padding, width);
        return this;
    }

    public TableView setWidth(int columnIndex, int width) {
        for (int row = 0; row < this.array.length; ++row) {
            this.array[row][columnIndex] = StringUtils.repeat(' ', width);
        }
        return this;
    }

    public String[] toStringArray(boolean rowBorder, boolean columnBorder) {
        String[][] copy = this.toArrayWithBorder(rowBorder, columnBorder);
        String[] data = new String[copy.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = ArrayUtils.join(copy[i], null, false);
        }
        return data;
    }

    public String[][] toArray() {
        return (String[][])this.array.clone();
    }

    public String[][] toArrayWithBorder(boolean rowBorder, boolean columnBorder) {
        String[][] copy = (String[][])this.array.clone();
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList<String> row = new ArrayList<String>();
        int rows = copy.length;
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            int l = copy[rowIndex].length;
            for (int columnIndex = 0; columnIndex < l; ++columnIndex) {
                row.add(copy[rowIndex][columnIndex]);
                if (!columnBorder || columnIndex == l - 1) continue;
                row.add("|");
            }
            row.add(0, "|");
            row.add("|");
            String[] rowArray = row.toArray(new String[0]);
            rowList.add(rowArray);
            if (rowBorder && rowIndex != rows - 1) {
                String[] border = this.getBorder(rowArray);
                rowList.add(border);
            }
            row.clear();
        }
        if (rowList.size() > 0) {
            String[] border = this.getBorder((String[])rowList.get(0));
            rowList.add(0, border);
            rowList.add(border.clone());
        }
        return (String[][])rowList.toArray((T[])new String[0][0]);
    }

    private String[] getBorder(String[] rowArray) {
        int length = rowArray.length;
        String[] border = (String[])ArrayUtils.newArray(String.class, length);
        for (int i = 1; i < length - 1; ++i) {
            border[i] = StringUtils.repeat('-', rowArray[i].length());
        }
        border[0] = "+";
        border[length - 1] = "+";
        return border;
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean rowBorder, boolean columnBorder) {
        String[] data = this.toStringArray(rowBorder, columnBorder);
        StringBuilder tableContent = new StringBuilder();
        int l = data.length;
        for (int i = 0; i < l; ++i) {
            tableContent.append(data[i]);
            if (i == l - 1) continue;
            tableContent.append(NEWLINE);
        }
        return tableContent.toString();
    }

    public static void main(String[] args) {
        TableView table = new TableView(10, 8, 10);
        System.out.println(table.toString());
    }
}

