/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.beans;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.beans.BeanPropertyAccessException;
import com.github.paganini2008.devtools.beans.PropertyFilter;
import com.github.paganini2008.devtools.beans.PropertyUtils;
import com.github.paganini2008.devtools.collection.MapUtils;
import com.github.paganini2008.devtools.reflection.MethodUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

public abstract class HashCodeBuilder {
    public static final int initialNonZeroOddNumber = 17;
    public static final int multiplierNonZeroOddNumber = 31;

    public static int reflectionHashCode(Object bean) {
        return HashCodeBuilder.reflectionHashCode(bean, (PropertyFilter)null);
    }

    public static int reflectionHashCode(Object bean, PropertyFilter filter) {
        return HashCodeBuilder.reflectionHashCode(bean, null, filter);
    }

    public static int reflectionHashCode(Object bean, Class<?> stopClass, PropertyFilter filter) {
        Assert.isNull(bean, "Source bean must not be null.", new Object[0]);
        Map<String, PropertyDescriptor> descriptors = PropertyUtils.getPropertyDescriptors(bean.getClass(), stopClass, filter);
        if (MapUtils.isEmpty(descriptors)) {
            return 0;
        }
        return HashCodeBuilder.reflectionHashCode(bean, descriptors.values());
    }

    private static int reflectionHashCode(Object bean, Collection<PropertyDescriptor> descriptors) {
        int hash = 17;
        for (PropertyDescriptor descriptor : descriptors) {
            hash += 31 * hash + HashCodeBuilder.reflectionHashCode(bean, descriptor);
        }
        return hash;
    }

    private static int reflectionHashCode(Object bean, PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        if (method != null) {
            try {
                Object value = MethodUtils.invokeMethod(bean, method, new Object[0]);
                return ObjectUtils.hashCode(value);
            }
            catch (Exception e) {
                throw new BeanPropertyAccessException(e.getMessage(), e);
            }
        }
        return 0;
    }
}

