/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.AbstractCache;
import com.github.paganini2008.devtools.cache.Cache;
import java.util.Set;

public class MasterStandbyCache
extends AbstractCache {
    private final Cache master;
    private final Cache backup;

    public MasterStandbyCache(Cache master, Cache backup) {
        this.master = master;
        this.backup = backup;
    }

    @Override
    public void putObject(Object key, Object value, boolean ifAbsent) {
        this.backup.putObject(key, value, ifAbsent);
        this.master.putObject(key, value, ifAbsent);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.master.hasKey(key) ? true : this.backup.hasKey(key);
    }

    @Override
    public Object getObject(Object key) {
        Object result = this.master.getObject(key);
        if (result == null && (result = this.backup.getObject(key)) != null) {
            this.master.putObject(key, result);
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        this.backup.removeObject(key);
        return this.master.removeObject(key);
    }

    @Override
    public Set<Object> keys() {
        Set<Object> keys = this.master.keys();
        if (keys == null) {
            keys = this.backup.keys();
        }
        return keys;
    }

    @Override
    public void clear() {
        this.backup.clear();
        this.master.clear();
    }

    @Override
    public int getSize() {
        return Math.max(this.master.getSize(), this.backup.getSize());
    }
}

