/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.cache;

import com.github.paganini2008.devtools.cache.AbstractCache;
import com.github.paganini2008.devtools.cache.Cache;
import com.github.paganini2008.devtools.cache.ExpiredCache;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class UncheckedExpiredCache
extends AbstractCache
implements ExpiredCache {
    private final Cache delegate;

    public UncheckedExpiredCache(Cache delegate) {
        this.delegate = delegate;
    }

    @Override
    public void putObject(Object key, Object value, boolean ifAbsent) {
        this.putObject(key, value, ifAbsent, -1);
    }

    @Override
    public void putObject(Object key, Object value, boolean ifAbsent, int expired) {
        DefaultCachedObject cachedObject = new DefaultCachedObject(value, System.currentTimeMillis(), expired);
        this.delegate.putObject(key, cachedObject, ifAbsent);
    }

    @Override
    public void setExpired(Object key, int expired) {
        DefaultCachedObject cachedObject = (DefaultCachedObject)this.delegate.getObject(key);
        if (cachedObject != null && !this.isExpired(cachedObject)) {
            cachedObject.expired = expired;
        }
    }

    @Override
    public Object getObject(Object key) {
        DefaultCachedObject cachedObject = (DefaultCachedObject)this.delegate.getObject(key);
        if (cachedObject != null) {
            if (this.isExpired(cachedObject)) {
                this.delegate.removeObject(key);
                return null;
            }
            return cachedObject.value;
        }
        return null;
    }

    protected boolean isExpired(ExpiredCache.CachedObject cachedObject) {
        return cachedObject.getExpired() > 0 && TimeUnit.MILLISECONDS.convert(cachedObject.getExpired(), TimeUnit.SECONDS) > System.currentTimeMillis() - cachedObject.getCreated();
    }

    @Override
    public Object removeObject(Object key) {
        DefaultCachedObject cachedObject = (DefaultCachedObject)this.delegate.removeObject(key);
        return cachedObject != null ? cachedObject.value : null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public Set<Object> keys() {
        return this.delegate.keys();
    }

    @Override
    public boolean hasKey(Object key) {
        return this.delegate.hasKey(key);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void close() {
    }

    static class DefaultCachedObject
    implements ExpiredCache.CachedObject {
        final Object value;
        final long created;
        int expired;

        DefaultCachedObject(Object value, long created, int expired) {
            this.value = value;
            this.created = created;
            this.expired = expired;
        }

        @Override
        public int getExpired() {
            return this.expired;
        }

        @Override
        public void setExpired(int expired) {
            this.expired = expired;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public long getCreated() {
            return this.created;
        }
    }
}

