/*
 * Decompiled with CFR 0.152.
 */
package com.github.paganini2008.devtools.collection;

import com.github.paganini2008.devtools.Assert;
import com.github.paganini2008.devtools.ObjectUtils;
import com.github.paganini2008.devtools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.function.Function;

public abstract class CollectionUtils {
    public static <T> Collection<T> unmodifiableCollection(T ... args) {
        return CollectionUtils.unmodifiableCollection(Arrays.asList(args));
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<T> args) {
        return args != null ? Collections.unmodifiableCollection(args) : Collections.EMPTY_LIST;
    }

    public static boolean isEmpty(Enumeration<?> e) {
        return !CollectionUtils.isNotEmpty(e);
    }

    public static boolean isNotEmpty(Enumeration<?> e) {
        return e == null ? false : e.hasMoreElements();
    }

    public static boolean isEmpty(Iterator<?> it) {
        return !CollectionUtils.isNotEmpty(it);
    }

    public static boolean isNotEmpty(Iterator<?> it) {
        return it == null ? false : it.hasNext();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null ? true : collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> T getLast(Enumeration<T> en) {
        return CollectionUtils.getLast(en, null);
    }

    public static <T> T getLast(Enumeration<T> en, T defaultValue) {
        T last;
        if (en == null || !en.hasMoreElements()) {
            return defaultValue;
        }
        do {
            last = en.nextElement();
        } while (en.hasMoreElements());
        return last;
    }

    public static <T> T getLast(Collection<T> c) {
        return CollectionUtils.getLast(c, null);
    }

    public static <T> T getLast(Collection<T> c, T defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return CollectionUtils.getLast(c.iterator());
    }

    public static <T> T getLast(Iterator<T> it) {
        return CollectionUtils.getLast(it, null);
    }

    public static <T> T getLast(Iterator<T> it, T defaultValue) {
        T last;
        if (it == null || !it.hasNext()) {
            return defaultValue;
        }
        do {
            last = it.next();
        } while (it.hasNext());
        return last;
    }

    public static <T> T get(Iterator<T> it, int index) {
        return CollectionUtils.get(it, index, null);
    }

    public static <T> T get(Iterator<T> it, int index, T defaultValue) {
        if (it == null || !it.hasNext()) {
            return defaultValue;
        }
        int i = 0;
        do {
            T find = it.next();
            if (i++ != index) continue;
            return find;
        } while (it.hasNext());
        return null;
    }

    public static <T> T get(Enumeration<T> en, int index) {
        return CollectionUtils.get(en, index, null);
    }

    public static <T> T get(Enumeration<T> en, int index, T defaultValue) {
        if (en == null || !en.hasMoreElements()) {
            return defaultValue;
        }
        int i = 0;
        do {
            T find = en.nextElement();
            if (i++ != index) continue;
            return find;
        } while (en.hasMoreElements());
        return null;
    }

    public static <T> T getFirst(Enumeration<T> en) {
        return CollectionUtils.getFirst(en, null);
    }

    public static <T> T getFirst(Enumeration<T> en, T defaultValue) {
        if (en != null && en.hasMoreElements()) {
            return en.nextElement();
        }
        return defaultValue;
    }

    public static <T> T getFirst(Iterator<T> it) {
        return CollectionUtils.getFirst(it, null);
    }

    public static <T> T getFirst(Iterator<T> it, T defaultValue) {
        if (it != null && it.hasNext()) {
            return it.next();
        }
        return defaultValue;
    }

    public static <T> T getFirst(Collection<T> c) {
        return CollectionUtils.getFirst(c, null);
    }

    public static <T> T getFirst(Collection<T> c, T defaultValue) {
        if (c == null) {
            return defaultValue;
        }
        return CollectionUtils.getFirst(c.iterator());
    }

    public static <T> Enumeration<T> enumeration(final T[] array) {
        return new Enumeration<T>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < array.length;
            }

            @Override
            public T nextElement() {
                return array[this.index++];
            }
        };
    }

    public static <T> Enumeration<T> enumeration(final Iterator<T> it) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public T nextElement() {
                return it.next();
            }
        };
    }

    public static <E> Iterator<E> emptyIterator() {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public E next() {
                throw new UnsupportedOperationException("next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    public static <E> Enumeration<E> emptyEnumeration() {
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public E nextElement() {
                throw new UnsupportedOperationException("nextElement");
            }
        };
    }

    public static <T> Iterator<T> iterator(final T[] array) {
        Assert.isNull(array, "Null array.", new Object[0]);
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public T next() {
                return array[this.index++];
            }
        };
    }

    public static <T> Iterator<T> iterator(final Enumeration<T> en) {
        Assert.isNull(en, "Null enumeration.", new Object[0]);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public T next() {
                return en.nextElement();
            }
        };
    }

    public static <T> Iterable<T> forEach(Iterator<T> delegate) {
        Assert.isNull(delegate, "Null iterator.", new Object[0]);
        return () -> delegate;
    }

    public static <T> List<T> toList(Iterator<T> delegate) {
        Assert.isNull(delegate, "Null iterator.", new Object[0]);
        ArrayList<T> list = new ArrayList<T>();
        while (delegate.hasNext()) {
            list.add(delegate.next());
        }
        return list;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    public static <T> Iterable<T> forEach(Enumeration<T> delegate) {
        return CollectionUtils.forEach(CollectionUtils.iterator(delegate));
    }

    public static <T> List<T> toList(Enumeration<T> delegate) {
        Assert.isNull(delegate, "Null enumeration.", new Object[0]);
        ArrayList<T> list = new ArrayList<T>();
        while (delegate.hasMoreElements()) {
            list.add(delegate.nextElement());
        }
        return list;
    }

    public static <E, T> Iterator<T> iterator(final Enumeration<E> delegate, final Function<E, T> getter) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return delegate.hasMoreElements();
            }

            @Override
            public T next() {
                return getter.apply(delegate.nextElement());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E, T> Iterator<T> iterator(final Iterator<E> delegate, final Function<E, T> getter) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public T next() {
                return getter.apply(delegate.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String toString(Iterable<?> c) {
        return "[" + CollectionUtils.join(c) + "]";
    }

    public static String toString(Iterator<?> it) {
        return "[" + CollectionUtils.join(it) + "]";
    }

    public static String toString(Enumeration<?> e) {
        return "[" + CollectionUtils.join(e) + "]";
    }

    public static String join(Iterable<?> c) {
        return CollectionUtils.join(c, ",");
    }

    public static String join(Iterable<?> c, String delimiter) {
        if (c == null) {
            return "";
        }
        return CollectionUtils.join(c.iterator(), delimiter);
    }

    public static String join(Iterable<?> left, Iterable<?> right, String delimiter) {
        return CollectionUtils.join(left, right, delimiter, delimiter);
    }

    public static String join(Iterable<?> left, Iterable<?> right, String conjunction, String delimiter) {
        if (left == null || right == null) {
            return "";
        }
        return CollectionUtils.join(left.iterator(), right.iterator(), conjunction, delimiter);
    }

    public static String join(Iterator<?> it) {
        return CollectionUtils.join(it, ",");
    }

    public static String join(Iterator<?> it, String delimiter) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        while (true) {
            Object o = it.next();
            content.append(ObjectUtils.toString(o));
            if (!it.hasNext()) break;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static String join(Iterator<?> it, String delimiter, String pattern) {
        if (it == null || !it.hasNext()) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        while (true) {
            Object o = it.next();
            String s = StringUtils.parseText(pattern, "{}", ObjectUtils.toString(o));
            content.append(s);
            if (!it.hasNext()) break;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static String join(Iterator<?> left, Iterator<?> right, String delimiter) {
        return CollectionUtils.join(left, right, delimiter, delimiter);
    }

    public static String join(Iterator<?> left, Iterator<?> right, String conjunction, String delimiter) {
        if (left == null || !left.hasNext() || right == null || !right.hasNext()) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        while (true) {
            content.append(ObjectUtils.toString(left.next())).append(conjunction).append(ObjectUtils.toString(right.next()));
            if (!left.hasNext() || !right.hasNext()) break;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static String join(Enumeration<?> e) {
        return CollectionUtils.join(e, ",");
    }

    public static String join(Enumeration<?> e, String delimiter) {
        if (e == null || !e.hasMoreElements()) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        while (true) {
            Object o = e.nextElement();
            content.append(ObjectUtils.toString(o));
            if (!e.hasMoreElements()) break;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static String join(Enumeration<?> left, Enumeration<?> right, String delimiter) {
        return CollectionUtils.join(left, right, delimiter, delimiter);
    }

    public static String join(Enumeration<?> left, Enumeration<?> right, String conjunction, String delimiter) {
        if (left == null || !left.hasMoreElements() || right == null || !right.hasMoreElements()) {
            return "";
        }
        if (conjunction == null) {
            conjunction = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder content = new StringBuilder();
        while (true) {
            content.append(ObjectUtils.toString(left.nextElement())).append(conjunction).append(ObjectUtils.toString(right.nextElement()));
            if (!left.hasMoreElements() || !right.hasMoreElements()) break;
            content.append(delimiter);
        }
        return content.toString();
    }

    public static boolean isCollection(Object obj) {
        return obj == null ? false : obj instanceof Collection;
    }

    public static boolean isNotCollection(Object obj) {
        return !CollectionUtils.isCollection(obj);
    }

    public static boolean isIterator(Object obj) {
        return obj == null ? false : obj instanceof Iterator;
    }

    public static boolean isNotIterator(Object obj) {
        return !CollectionUtils.isIterator(obj);
    }

    public static boolean isEnumeration(Object obj) {
        return obj == null ? false : obj instanceof Enumeration;
    }

    public static boolean isNotEnumeration(Object obj) {
        return !CollectionUtils.isEnumeration(obj);
    }

    public static boolean isQueue(Object obj) {
        return obj == null ? false : obj instanceof Queue;
    }

    public static boolean isNotQueue(Object obj) {
        return !CollectionUtils.isQueue(obj);
    }

    public static boolean deepEquals(Iterable<?> left, Iterable<?> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        return CollectionUtils.deepEquals(left.iterator(), right.iterator());
    }

    public static boolean deepEquals(Iterator<?> left, Iterator<?> right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        while (left.hasNext() && right.hasNext()) {
            Object o2;
            Object o1 = left.next();
            if (!ObjectUtils.notEquals(o1, o2 = right.next())) continue;
            return false;
        }
        return !left.hasNext() && !right.hasNext();
    }

    public static boolean deepEquals(Enumeration<?> left, Enumeration<?> right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return false;
        }
        if (left.getClass() != right.getClass()) {
            return false;
        }
        while (left.hasMoreElements() && right.hasMoreElements()) {
            Object o2;
            Object o1 = left.nextElement();
            if (!ObjectUtils.notEquals(o1, o2 = right.nextElement())) continue;
            return false;
        }
        return !left.hasMoreElements() && !right.hasMoreElements();
    }

    public static int deepHashCode(Iterable<?> it) {
        if (it == null) {
            return 0;
        }
        return CollectionUtils.deepHashCode(it.iterator());
    }

    public static int deepHashCode(Iterator<?> it) {
        if (it == null) {
            return 0;
        }
        int prime = 31;
        int hash = 1;
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null) continue;
            hash = prime * hash + ObjectUtils.hashCode(o);
        }
        return hash;
    }

    public static int deepHashCode(Enumeration<?> en) {
        if (en == null) {
            return 0;
        }
        int prime = 31;
        int hash = 1;
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (o == null) continue;
            hash = prime * hash + ObjectUtils.hashCode(o);
        }
        return hash;
    }

    public static boolean containsIgnoreCase(Collection<String> c, String s) {
        if (c != null) {
            for (String a : c) {
                if (!StringUtils.equalsIgnoreCase(a, s)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Collection<T> minus(Collection<T> left, Collection<T> right) {
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left != null && right != null) {
            ArrayList<T> results = new ArrayList<T>();
            for (T t : left) {
                if (right.contains(t)) continue;
                results.add(t);
            }
            return results;
        }
        return null;
    }

    public static <T> Collection<T> intersect(Collection<T> left, Collection<T> right) {
        if (left == null || right == null) {
            return null;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T t : left) {
            if (!right.contains(t)) continue;
            results.add(t);
        }
        return results;
    }

    public static <T> Collection<T> union(Collection<T> left, Collection<T> right) {
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left != null && right != null) {
            ArrayList<T> list = new ArrayList<T>();
            for (T t : left) {
                if (list.contains(t)) continue;
                list.add(t);
            }
            for (T t : right) {
                if (list.contains(t)) continue;
                list.add(t);
            }
            return list;
        }
        return null;
    }

    public static <T> Collection<T> unionAll(Collection<T> left, Collection<T> right) {
        if (left != null && right == null) {
            return left;
        }
        if (left == null && right != null) {
            return right;
        }
        if (left != null && right != null) {
            ArrayList<T> results = new ArrayList<T>();
            results.addAll(left);
            results.addAll(right);
            return results;
        }
        return null;
    }

    public static <T> void addAll(Collection<T> c, T[] elements) {
        int size = elements.length;
        for (int i = 0; i < size; ++i) {
            c.add(elements[i]);
        }
    }

    public static <T> void addAll(Collection<T> c, Iterator<T> it) {
        while (it.hasNext()) {
            c.add(it.next());
        }
    }

    public static <T> void addAll(Collection<T> c, Enumeration<T> en) {
        while (en.hasMoreElements()) {
            c.add(en.nextElement());
        }
    }

    public static List<String> formats(Collection<?> src, String format) {
        Assert.isNull(src, "List must not be null.", new Object[0]);
        return CollectionUtils.formats(src.iterator(), format);
    }

    public static List<String> formats(Enumeration<?> src, String format) {
        Assert.isNull(src, "Enumeration must not be null.", new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        while (src.hasMoreElements()) {
            list.add(String.format(format, src.nextElement()));
        }
        return list;
    }

    public static List<String> formats(Iterator<?> src, String format) {
        Assert.isNull(src, "Iterator must not be null.", new Object[0]);
        ArrayList<String> list = new ArrayList<String>();
        while (src.hasNext()) {
            list.add(String.format(format, src.next()));
        }
        return list;
    }

    public static <T> Iterator<T> toSequentialIterator(Collection<Iterator<T>> c) {
        return new SequentialIterator<T>(c);
    }

    public static <T> Iterator<T> toSequentialEnumeration(Collection<Enumeration<T>> c) {
        return new SequentialEnumeration<T>(c);
    }

    public static class SequentialIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> iterator;
        private Iterator<T> item;

        SequentialIterator(Collection<Iterator<T>> c) {
            if (c == null) {
                throw new NullPointerException("Null collection");
            }
            this.iterator = c.iterator();
            this.item = this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.item != null && this.item.hasNext();
        }

        @Override
        public T next() {
            T t = this.item.next();
            if (!this.item.hasNext()) {
                this.item = this.iterator.hasNext() ? this.iterator.next() : null;
            }
            return t;
        }
    }

    public static class SequentialEnumeration<T>
    implements Iterator<T> {
        private final Iterator<Enumeration<T>> iterator;
        private Enumeration<T> item;

        SequentialEnumeration(Collection<Enumeration<T>> c) {
            if (c == null) {
                throw new NullPointerException("Null collection");
            }
            this.iterator = c.iterator();
            this.item = this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.item != null && this.item.hasMoreElements();
        }

        @Override
        public T next() {
            T t = this.item.nextElement();
            if (!this.item.hasMoreElements()) {
                this.item = this.iterator.hasNext() ? this.iterator.next() : null;
            }
            return t;
        }
    }
}

